#include <Wt/WApplication>
#include <Wt/WBootstrapTheme>
#include <Wt/WStandardItem>
#include <Wt/WStandardItemModel>
#include <Wt/WStringListModel>
#include <Wt/WTableView>
#include <Wt/WItemDelegate>
#include <Wt/WContainerWidget>
#include <Wt/WComboBox>
#include <Wt/WLabel>
#include <Wt/WPushButton>

#include "Sample.h"

/*
 * This delegate demonstrates how to override the editing behaviour of a
 * table cell.
 *
 * It takes a list of possible items on construction and, when edited, saves
 * the selected item from the list to the Wt::DisplayRole in the model for
 * Wt::WItemDelegate to render.
 * It also saves the items index for future editing (rather than each time
 * searching the item in the list). This is done using the general purpose
 * Wt::UserRole in the model.
 */
class ComboDelegate : public Wt::WItemDelegate {
  public:
  Wt::WWidget *update(Wt::WWidget *pWidget, const Wt::WModelIndex &index, Wt::WFlags<Wt::ViewItemRenderFlag> flags)
  {
    if (pWidget) return pWidget;

    auto l = new Wt::WLabel("label");
    l->setToolTip("ToolTip", Wt::PlainText);

    // causes browser memory leak (drag slider in vertical scrollbar rapidly up and down)
    l->setDeferredToolTip(true);

    return l;
  }
};

SAMPLE_BEGIN(ComboDelegateTable)

Wt::WTableView *table = new Wt::WTableView();


Wt::WStandardItemModel *model = new Wt::WStandardItemModel(table);
for (unsigned i=0; i < 1000; i++) {
  for (unsigned j=0; j < 2; j++) {
    Wt::WStandardItem *item = new Wt::WStandardItem();
    model->setItem(i, j, item);
  }
}

// create table
table->setModel(model);
table->setEditTriggers(Wt::WAbstractItemView::SingleClicked);
ComboDelegate* customdelegate = new ComboDelegate();
table->setItemDelegate(customdelegate);

table->setSortingEnabled(false);
table->setColumnResizeEnabled(false);
table->setRowHeight(40);
table->setHeaderHeight(0);

const int WIDTH = 120;
for (int i = 0; i < table->model()->columnCount(); ++i)
table->setColumnWidth(i, WIDTH);
table->setWidth((WIDTH + 7) * table->model()->columnCount() + 2);
table->setHeight(300);

SAMPLE_END(return table)


Wt::WApplication *createApplication(const Wt::WEnvironment& env)
{
  Wt::WApplication* app = new Wt::WApplication(env);

//  auto theme = new Wt::WBootstrapTheme(app);
//  theme->setVersion(Wt::WBootstrapTheme::Version3);

  auto pw = ComboDelegateTable();

  app->root()->addWidget(pw);

  return app;
}

int main(int argc, char **argv)
{
  return Wt::WRun(argc, argv, &createApplication);
}
