// popup.cpp : This file contains the 'main' function. Program execution begins and ends there.
//

#pragma warning(push)
#pragma warning(disable: 4267) // wt\wstringstream.h(110): warning C4267: 'argument': conversion from 'size_t' to 'int', possible loss of data
#include <Wt/WApplication.h>
#include <Wt/WContainerWidget.h>
#include <Wt/WVBoxLayout.h>
#include <Wt/WText.h>
#include <Wt/WLineEdit.h>
#include <Wt/WCompositeWidget.h>
#include <Wt/WCssStyleSheet.h>
#include <Wt/WPushButton.h>
#include <Wt/WDialog.h>
#include <Wt/WPopupMenu.h>
#include <Wt/WWidget.h>
#include <Wt/WTableView.h>
#include <Wt/WStandardItemModel.h>
#include <Wt/WStandardItem.h>
#pragma warning(pop)


using namespace Wt;
using std::make_unique;

class App : public Wt::WApplication {
public:
  App (const Wt::WEnvironment& env) : WApplication(env) 
  {
    auto layout = CreateWidgets(root());

    auto btnDlg = layout->addWidget(make_unique<WPushButton>("dlg"));
    btnDlg->clicked().connect(this, &App::OpenDialog);
  }

  void OpenDialog () 
  {
    auto dlg = make_unique<WDialog>("title");
    auto layout = CreateWidgets(dlg->contents());

    dlg->finished().connect([this, ptrdlg = dlg.get()] () {
      removeChild(ptrdlg);
    });

    dlg->setClosable(true);
    dlg->setResizable(true);
    dlg->show();

    addChild(std::move(dlg));
  }

  std::unique_ptr<Wt::WTableView> DummyTable () 
  {
    auto table = std::make_unique<WTableView>();

    auto model = std::make_shared<WStandardItemModel>();
    for (int ri = 0; ri < 20; ++ri) {
      std::vector<std::unique_ptr<WStandardItem>> row(5);
      for (int ci = 0; ci < 5; ++ci) {
        row[ci] = std::make_unique<WStandardItem>(std::to_string(ri) + " " + std::to_string(ci));
      } 
      model->appendRow(std::move(row));
    }
    table->setModel(model);

    table->setDragEnabled(true);
    table->setDropsEnabled(true);

    return table;
  }

  Wt::WVBoxLayout* CreateWidgets (Wt::WContainerWidget* root) 
  {
    auto wrapper = root->setLayout(make_unique<WVBoxLayout>());
    auto scollarea = wrapper->addWidget(make_unique<WContainerWidget>());
    scollarea->setOverflow(Overflow::Auto);

    auto contents = scollarea->addWidget(make_unique<WContainerWidget>());
    auto layout = contents->setLayout(make_unique<WVBoxLayout>());

    layout->addWidget(DummyTable(), 1);

    return layout;
  }






  static std::unique_ptr<Wt::WApplication> Create (const Wt::WEnvironment& env) 
  {
    return std::make_unique<App>(env);
  }
};











#include <iostream>
#include <Wt/WServer.h>

int main(int argc, char** argv)
{
  try {
    //Wt::WLayout::setDefaultImplementation(Wt::LayoutImplementation::JavaScript); // use old layout behaviour

    Wt::WServer server(argc, argv);
    server.addEntryPoint(Wt::EntryPointType::Application, &App::Create);

    server.run();

    return EXIT_SUCCESS;
  }
  catch (std::exception& e) {
    std::cerr << e.what() << "\n";
    return EXIT_FAILURE;
  }
}
