
#include <Wt/WServer.h>
#include <Wt/WApplication.h>
#include <Wt/WContainerWidget.h>
#include <Wt/WText.h>
#include <Wt/WVBoxLayout.h>
#include <Wt/WCompositeWidget.h>

#include <iostream>
#include <memory>
#include <thread>
#include <random>
#include <atomic>

// CMD:
// C:> wt-deadlock-test --http-address 0.0.0.0 --docroot C:\Users\Benutzter\source\repos\emweb\wt-4.3.1-build-debug-install\share\Wt

// <Meta + R> http://localhost/



class MyApp : public Wt::WApplication {

private:
   Wt::WText* text{};
   std::atomic<int> count{};

public:

   static std::unique_ptr<Wt::WApplication> CreateApp(const Wt::WEnvironment& env) 
   {
      return std::make_unique<MyApp>(env);
   }



   MyApp (const Wt::WEnvironment& env) 
   : Wt::WApplication(env) 
   {
      auto layout = root()->setLayout(std::make_unique<Wt::WVBoxLayout>());
      text = layout->addWidget(std::make_unique<Wt::WText>("warming up..."));

      layout->addStretch(1);



      const auto sessionid = wApp->sessionId();

      const auto finishcb = bindSafe([&] () {
         if (--count == 0) {
            text->setText("done");
         }
         else {
            text->setText("loading: " + std::to_string(count));
         }
         
         wApp->triggerUpdate(); 
         wApp->enableUpdates(false);
      });

      constexpr int CONCURRENCY = 32;
      for (int i = 0; i < CONCURRENCY; ++i) {
         ++count;
         wApp->enableUpdates(true);

         std::thread{[sessionid, finishcb] () {
            std::random_device rd;
            std::mt19937 gen(rd());
            std::uniform_int_distribution<> distrib(1, 6);
            std::this_thread::sleep_for(std::chrono::seconds(distrib(gen)));

            Wt::WServer::instance()->post(sessionid, finishcb);
         }}.detach();
      }

   }


};


int main(int argc, char** argv)
try {
   Wt::WServer wserver{argc, argv};

   wserver.addEntryPoint(Wt::EntryPointType::Application, &MyApp::CreateApp);

   wserver.run();
   return wserver.waitForShutdown();
}
catch (std::exception& e) {
   std::cerr << e.what() << std::endl;
   return EXIT_FAILURE;
}

