#include <Wt/WApplication.h>
#include <Wt/WContainerWidget.h>
#include <Wt/WSuggestionPopup.h>
#include <Wt/WLineEdit.h>
#include <Wt/WText.h>
#include <Wt/WEnvironment.h>

using namespace Wt;

/*
 * HACK: The following is for debugging purposes only to gain access to exposedSignals_
 */

struct ExposedInfo {
  int total = 0;
  int scrollVisibilityChanged = 0;
};

struct ExposedInfoPtr {
  ExposedInfoPtr(ExposedInfo* info_in) : info(info_in) { }
  ExposedInfo* info;
};

template <>
ExposedInfoPtr* WContainerWidget::addWidget(std::unique_ptr<ExposedInfoPtr> infoPtr)
{
  static const char SVC[] = ".scrollVisibilityChanged";

  auto info = infoPtr->info;
  info->total = wApp->exposedSignals_.size();

  for (auto sig: wApp->exposedSignals_) {
    if (sig.first.size() > sizeof SVC
        && sig.first.substr(sig.first.size() - sizeof SVC + 1) == SVC)
      info->scrollVisibilityChanged++;
  }

  log("info") << "Summary of exposedSignals, total: " << info->total
    << ", scrollVisibilityChanged: " << info->scrollVisibilityChanged;
#if 0
  for (auto sig: wApp->exposedSignals_) {
    log("info") << "    " << sig.first;
  }
#endif
  return infoPtr.get();
}

class TestApp : public WApplication {
public:
  TestApp(const WEnvironment& env);

  ExposedInfo debugDisplaySignals() const;
};

ExposedInfo TestApp::debugDisplaySignals() const
{
  ExposedInfo info;
  auto infoPtr = cpp14::make_unique<ExposedInfoPtr>(&info);
  auto exposedInfoPtr = root()->addWidget(std::move(infoPtr));
  return info;
}

TestApp::TestApp(const WEnvironment& env) : WApplication(env)
{
  setTitle("Excessive exposedSignals for ScrollVisibility");
  styleSheet().addRule(".Wt-suggest b", "color: green;");

  WSuggestionPopup::Options simpleOptions;
  simpleOptions.highlightBeginTag = "<b>";
  simpleOptions.highlightEndTag = "</b>";
  simpleOptions.listSeparator = 0;

  auto popup = cpp14::make_unique<WSuggestionPopup>(simpleOptions);
  popup->setMinimumSize(WLength(80), WLength::Auto);
  popup->setMaximumSize(WLength::Auto, WLength(200));

  auto lineEdit = cpp14::make_unique<WLineEdit>();
  lineEdit->setWidth(200);
  lineEdit->setPlaceholderText("Enter a 3-digit number");
  lineEdit->setFocus();

  char buf[4];
  for (unsigned i = 0; i < 1000; ++i) {
    snprintf(buf, sizeof buf, "%03d", i);
    popup->addSuggestion(std::string(buf));
  }

  popup->forEdit(lineEdit.get());
  root()->addChild(std::move(popup));

  auto info = debugDisplaySignals();
  root()->addNew<WText>("Total exposedSignals: " + std::to_string(info.total)
      + ", scrollVisibilityChanged: " + std::to_string(info.scrollVisibilityChanged) + "<br/>");

  root()->addWidget(std::move(lineEdit));
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, [](const WEnvironment& env) {return std::make_unique<TestApp>(env);});
}
