#include <Wt/WApplication.h>
#include <Wt/WBootstrapTheme.h>
#include <Wt/WServer.h>

#include <Wt/WContainerWidget.h>
#include <Wt/WText.h>
#include <Wt/WHBoxLayout.h>
#include <Wt/WPushButton.h>
#include <Wt/WPopupMenu.h>


using namespace Wt;



// -----------------------------------------------------------------------------------
std::unique_ptr<WApplication> createHelloApplication(const WEnvironment &env)
{
    auto app = std::make_unique<Wt::WApplication>(env);

    auto theme = std::make_shared<Wt::WBootstrapTheme>();
    theme->setVersion(Wt::BootstrapVersion::v3);
    app->setTheme(theme);

    WHBoxLayout *mainLayout = app->root()->setLayout(std::make_unique<WHBoxLayout>());

    auto leftCont = mainLayout->addWidget(std::make_unique<WContainerWidget>(), 1);
    leftCont->setOverflow(Overflow::Auto);
    leftCont->addWidget(std::make_unique<WText>("Left Container"));

    auto toolsCont = leftCont->addWidget(std::make_unique<WContainerWidget>());
    auto toolsLayout = toolsCont->setLayout(std::make_unique<WHBoxLayout>());

    toolsLayout->addWidget(std::make_unique<WText>("Click the right button to dipslay the popup"), 1);

    auto toolsPopup = std::make_unique<WPopupMenu>();

    toolsPopup->addItem("Long Long Long Demo Item 1");
    toolsPopup->addItem("Long Long Long Demo Item 2");
    toolsPopup->addItem("Long Long Long Demo Item 3");
    toolsPopup->addItem("Long Long Long Demo Item 4");
    toolsPopup->addItem("Long Long Long Demo Item 5");

    auto popupBt = toolsLayout->addWidget(std::make_unique<WPushButton>("Click here"));
    popupBt->setMenu(std::move(toolsPopup));

    for (int i = 0; i < 100; i++)
        leftCont->addWidget(std::make_unique<WText>("Popup Error Sample Line " + std::to_string(i)))->setInline(false);

    auto rightCont = mainLayout->addWidget(std::make_unique<WContainerWidget>());
    rightCont->setWidth(200);
    rightCont->addWidget(std::make_unique<WText>("Right Container"));

    return app;
}


// -----------------------------------------------------------------------------------
int main(int argc, char *argv[])
{
    try
    {
        WServer server(argc, argv, WTHTTP_CONFIGURATION);

        server.addEntryPoint(EntryPointType::Application,
                             std::bind(&createHelloApplication, std::placeholders::_1));

        if (server.start())
        {
          int sig = WServer::waitForShutdown();

          std::cerr << "*** Shutdown (signal = " << sig << ")" << std::endl;
          server.stop();

          if (sig == 1) // SIGHUP
            WServer::restart(argc, argv, environ);

          return 0;
        }
    }
    catch (WServer::Exception &e)
    {
        std::cerr << "*** Server Exception: " << e.what() << std::endl;
    }
    catch (std::exception &e)
    {
        std::cerr << "*** Std Exception: " << e.what() << std::endl;
    }
}
