#include <Wt/Chart/WCartesianChart.h>
#include <Wt/WApplication.h>
#include <Wt/WEnvironment.h>
#include <Wt/WFont.h>
#include <Wt/WHBoxLayout.h>

using namespace Wt;

class TestApp : public WApplication {
public:
  TestApp(const WEnvironment& env);
};

TestApp::TestApp(const WEnvironment& env) : WApplication(env)
{
  setTitle("Test WCartesianChart clipping of title descenders");
  auto root_layout = root()->setLayout(std::make_unique<WHBoxLayout>());
  root_layout->setContentsMargins(0, 0, 0, 0);
  std::vector<Chart::WCartesianChart *> charts;

  // note: template parameters not needed with std++17
  static std::array<std::pair<RenderMethod, std::string>, 3> const methods {
      std::make_pair(RenderMethod::HtmlCanvas,   "canvas"),
      std::make_pair(RenderMethod::PngImage,     "png"   ),
      std::make_pair(RenderMethod::InlineSvgVml, "svg"   )
  };

  WFont title_font;
  title_font.setFamily(FontFamily::SansSerif, "Arial");
  title_font.setSize(20);

  for (auto method: methods) {
    charts.push_back(root_layout->addWidget(std::make_unique<Chart::WCartesianChart>()));
    auto chart = charts.back();
    chart->setTitleFont(title_font);
    chart->setPreferredMethod(method.first);
    chart->setTitle(std::string(method.second) + ": The quick brown fox jumps over the lazy dog");
  }
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, [](const WEnvironment& env) {return std::make_unique<TestApp>(env);});
}
