#include <Wt/WApplication.h>
#include <Wt/WBrush.h>
#include <Wt/WColor.h>
#include <Wt/WContainerWidget.h>
#include <Wt/WEnvironment.h>
#include <Wt/WFont.h>
#include <Wt/WPaintedWidget.h>
#include <Wt/WPainter.h>
#include <Wt/WPen.h>
#include <Wt/WRectF.h>
#include <Wt/WText.h>

using namespace Wt;

class PaintedWidget : public WPaintedWidget
{
public:
  PaintedWidget(AlignmentFlag alignment, WFont& title_font) :
    Wt::WPaintedWidget(), alignment_(alignment), titleFont_(title_font) { }
  ~PaintedWidget() { }

protected:
  void paintEvent(WPaintDevice *paintDevice) {
    WPainter painter(paintDevice);

    auto rect = WRectF(0, 0, 800, 30);
    WString text("The quick brown fox jumped over the lazy dog");

    painter.fillRect(rect, WBrush(StandardColor::Yellow));

    painter.setFont(titleFont_);
    painter.drawText(rect, WFlags<AlignmentFlag>(AlignmentFlag::Center) | alignment_, text);
  }

private:
  AlignmentFlag alignment_;
  WFont titleFont_;
};

class TestApp : public WApplication {
public:
  TestApp(const WEnvironment& env);
};

TestApp::TestApp(const WEnvironment& env) : WApplication(env)
{
  setTitle("Test font clipping");

  static std::array<std::pair<AlignmentFlag, std::string>, 3> const alignments {
      std::make_pair(AlignmentFlag::Top,    "Top"),
      std::make_pair(AlignmentFlag::Middle, "Middle"),
      std::make_pair(AlignmentFlag::Bottom, "Bottom")
  };

  static std::array<std::pair<RenderMethod, std::string>, 3> const methods {
      std::make_pair(RenderMethod::HtmlCanvas,   "canvas"),
      std::make_pair(RenderMethod::PngImage,     "png"   ),
      std::make_pair(RenderMethod::InlineSvgVml, "svg"   )
  };

  auto title_font = WFont();

  /*
   * for testing, manually switch size and font families...
   */
  title_font.setSize(WLength(30));
  title_font.setFamily(FontFamily::SansSerif, "Arial");
//  title_font.setFamily(FontFamily::Serif, "'DejaVu Serif'");

  for (auto alignment: alignments) {
    root()->addNew<WText>(std::string("<strong>======= alignment: ") +
        alignment.second + " =======</strong><br/>");
    for (auto method: methods) {
      root()->addNew<WText>(std::string("method: ") + method.second);
      auto pw = root()->addNew<PaintedWidget>(alignment.first, title_font);
      pw->resize(800, 50);
      pw->setPreferredMethod(method.first);
    }
  }
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, [](const WEnvironment& env) {return std::make_unique<TestApp>(env);});
}
