/*
* Copyright (C) 2008 Emweb bvba, Heverlee, Belgium.
*
* See the LICENSE file for terms of use.
*/

#include <Wt/WApplication.h>
#include <Wt/WBreak.h>
#include <Wt/WContainerWidget.h>
#include <Wt/WLineEdit.h>
#include <Wt/WPushButton.h>
#include <Wt/WText.h>
#include <Wt/WStackedWidget.h>
#include <Wt/WHBoxLayout.h>
#include <Wt/WLength.h>
#include <Wt/WStandardItemModel.h>
#include <Wt/Chart/WCartesianChart.h>
#include <Wt/WFlags.h>
#include <Wt/WResource.h>
#include <Wt/WPainter.h>
#include <Wt/WPdfImage.h>
#include <Wt/WResource.h>
#include <Wt/Http/Request.h>
#include <Wt/Http/Response.h>
#include <Wt/Render/WPdfRenderer.h>
#include <hpdf.h>
#include <Wt/WVBoxLayout.h>
#include <Wt/WDatePicker.h>

using namespace Wt;
using namespace Wt::Chart;

namespace {
	void HPDF_STDCALL error_handler(HPDF_STATUS error_no, HPDF_STATUS detail_no, void *user_data)
	{
		fprintf(stderr, "libharu error: error_no=%04X, detail_no=%d\n",
			(unsigned int)error_no, (int)detail_no);
	}
}

class ReportResource : public Wt::WResource
{
public:
	ReportResource();
	virtual ~ReportResource();

	virtual void handleRequest(const Wt::Http::Request& request,
		Wt::Http::Response& response);

};

//GLobal pointer for test
WCartesianChart *chart = NULL;

class HelloApplication : public Wt::WApplication
{
public:
	HelloApplication(const Wt::WEnvironment& env);

private:



};


HelloApplication::HelloApplication(const Wt::WEnvironment& env)
	: WApplication(env)
{


	setTitle("Hello world");                 

	//Main Container
	Wt::WContainerWidget *pCont1 = root()->addWidget(Wt::cpp14::make_unique<Wt::WContainerWidget>()); 
	pCont1->setWidth(Wt::WLength(100, Wt::WLength::Unit::Percentage));
	pCont1->setHeight(Wt::WLength(100, Wt::WLength::Unit::Percentage));
	pCont1->decorationStyle().setBackgroundColor(Wt::WColor("rgb(192,192,192)"));

	Wt::WVBoxLayout *pLayout = pCont1->setLayout(Wt::cpp14::make_unique<WVBoxLayout>());

	//Create Test-Model
	std::shared_ptr<WStandardItemModel> model
		= std::make_shared<WStandardItemModel>();

	//headers
	model->insertColumns(model->columnCount(), 2);
	model->setHeaderData(0, WString("Day"));
	model->setHeaderData(1, WString("Sales"));

	//data
	model->insertRows(model->rowCount(), 6);
	int row = 0;
	model->setData(row, 0, 1);
	model->setData(row, 1, 120);
	row++;
	model->setData(row, 0, 2);
	model->setData(row, 1, 30);
	row++;
	model->setData(row, 0, 3);
	model->setData(row, 1, 260);
	row++;
	model->setData(row, 0, 4);
	model->setData(row, 1, 160);
	row++;
	model->setData(row, 0, 5);
	model->setData(row, 1, 40);
	row++;
	model->setData(row, 0, 6);
	model->setData(row, 1, 120);
	row++;

	//Create Category Chart
	chart = pLayout->addWidget(cpp14::make_unique<WCartesianChart>());
	chart->setModel(model);
	chart->setXSeriesColumn(0);
	chart->setZoomEnabled(true);
	chart->setBackground(WColor(200, 200, 200));

	Wt::Chart::WheelActions actions;
	WFlags<KeyboardModifier> fl(KeyboardModifier::None);
	actions.insert(std::pair< WFlags<KeyboardModifier>, Wt::Chart::InteractiveAction>(fl, (Wt::Chart::InteractiveAction::ZoomX)));
	chart->setWheelActions(actions);
	
	for (int i = 1; i < model->columnCount(); ++i) 
	{
		std::unique_ptr<WDataSeries> s
			= cpp14::make_unique<WDataSeries>(i, SeriesType::Bar);
		s->setShadow(WShadow(3, 3, WColor(0, 0, 0, 127), 3));
		chart->addSeries(std::move(s));
	}
	chart->resize(800, 400);

	WPushButton *btn_pdf = pLayout->addWidget(cpp14::make_unique<WPushButton>("Print Pdf"));
	auto r = std::make_shared<ReportResource>();
	btn_pdf->setLink(WLink(r));
	btn_pdf->resize("120px", "30px");

	Wt::WDatePicker *picker = pLayout->addWidget(cpp14::make_unique<WDatePicker>());

}

//Report Resource
ReportResource::ReportResource() : WResource()
{
	suggestFileName("report.pdf");
}

ReportResource::~ReportResource()
{
	beingDeleted();
}

void ReportResource::handleRequest(const Wt::Http::Request& request, Wt::Http::Response& response)
{
	response.setMimeType("application/pdf");
	HPDF_Doc pdf = HPDF_New(error_handler, 0);

	// Note: UTF-8 encoding (for TrueType fonts) is only available since libharu 2.3.0 !
	HPDF_UseUTFEncodings(pdf);

	HPDF_Page page = HPDF_AddPage(pdf);
	HPDF_Page_SetSize(page, HPDF_PAGE_SIZE_A4, HPDF_PAGE_PORTRAIT);

	Wt::Render::WPdfRenderer renderer(pdf, page);
	renderer.setMargin(2.54);
	renderer.setDpi(96);
	renderer.render(Wt::WString("<html><b>Hallo pdf</b></html>"));

	if (chart)
	{
		WPdfImage pdfImage(pdf, page, 0, 0, 600, 400);
		{
			WPainter p(&pdfImage);
			chart->paint(p);
		}
	}

	HPDF_SaveToStream(pdf);
	unsigned int size = HPDF_GetStreamSize(pdf);
	HPDF_BYTE *buf = new HPDF_BYTE[size];
	HPDF_ReadFromStream(pdf, buf, &size);
	HPDF_Free(pdf);
	response.out().write((char*)buf, size);
	delete[] buf;
}



int main(int argc, char **argv)
{
	return Wt::WRun(argc, argv, [](const Wt::WEnvironment &env) {
		return Wt::cpp14::make_unique<HelloApplication>(env);
	});
}
