/*
 * Copyright (C) 2008 Emweb bvba, Heverlee, Belgium.
 *
 * See the LICENSE file for terms of use.
 */

#include <Wt/WApplication>
#include <Wt/WBreak>
#include <Wt/WContainerWidget>
#include <Wt/WLineEdit>
#include <Wt/WPushButton>
#include <Wt/WText>
#include <Wt/WResource>
#include <Wt/Http/ResponseContinuation>
#include <Wt/Http/Response>
#include <Wt/WAnchor>
#include <Wt/WServer>

using namespace Wt;

class HelloApplication : public WApplication
{
public:
  HelloApplication(const WEnvironment& env);
};

class MyResource : public Wt::WResource
{
public:
  MyResource(int iterations, Wt::WObject *parent = 0)
    : Wt::WResource(parent),
      iterations_(iterations)
  {
    suggestFileName("data.txt");
  }

  ~MyResource() {
    beingDeleted();
  }

  void handleRequest(const Wt::Http::Request& request,
                     Wt::Http::Response& response) {
                              // see if this request is for a continuation:
       Wt::Http::ResponseContinuation *continuation = request.continuation();

       // calculate the current start
       int iteration = 
	 continuation ? boost::any_cast<int>(continuation->data()) : 0;
       if (iteration == 0)
               response.setMimeType("application/xml");

       int last = (std::min)(10, iteration + 2);
       std::cout << "RSSFeed: last: " << last <<  std::endl;

       for (int i = iteration; i < last; ++i)
       {
               response.out() << "Data item " << i << std::endl;
               std::cout << "RSSFeed: " << i <<  std::endl;
       }

       // if we have not yet finished, create a continuation to serve more
       if (last < 10) {
               std::cout << "RSSFeed: continuation" <<  std::endl;
               continuation = response.createContinuation();
               // remember what to do next
               continuation->setData(last);
       }
  }

private:
  int iterations_;
};

HelloApplication::HelloApplication(const WEnvironment& env)
  : WApplication(env)
{
  new WAnchor(new MyResource(10, root()), "click here", root());
}

WApplication *createApplication(const WEnvironment& env)
{
  return new HelloApplication(env);
}

namespace {
int MyRun(int argc, char *argv[], ApplicationCreator createApplication)
{
  try {
    WServer server(argv[0]);

    // WTHTTP_CONFIGURATION is e.g. "/etc/wt/wthttpd"
    server.setServerConfiguration(argc, argv, WTHTTP_CONFIGURATION);

    server.addResource(new MyResource(100), "/feed/rss2");
    // add a single entry point, at the default location (as determined
    // by the server configuration's deploy-path)
    server.addEntryPoint(Wt::Application, createApplication);
    if (server.start()) {
      while(true) sleep(1000);
    }
  } catch (WServer::Exception& e) {
    std::cerr << e.what() << "\n";
    return 1;
  } catch (std::exception& e) {
    std::cerr << "exception: " << e.what() << "\n";
    return 1;
  }
}
}
int main(int argc, char **argv)
{
  return MyRun(argc, argv, &createApplication);
}

