#include <Wt/WApplication.h>
//#include <Wt/WContainerWidget.h>
#include <Wt/WText.h>
#include <Wt/WMenu.h>
#include <Wt/WStackedWidget.h>
//#include <Wt/WTextArea.h>


// ./helloMenu --docroot /tmp --http-listen 0.0.0.0

class MenuApplication : public Wt::WApplication
{
	public:
		MenuApplication(const Wt::WEnvironment& env);

	private:
		Wt::WMenu *menu_;
		Wt::WStackedWidget *stack_;

};

MenuApplication::MenuApplication(const Wt::WEnvironment& env)
	: WApplication(env),
	menu_(nullptr),
	stack_(nullptr)
{
	WApplication::styleSheet().addRule(".item","color: #0000FF;","hui");
	WApplication::styleSheet().addRule(".itemselected","color: #FF0000;","huis");
	WApplication::styleSheet().addRule(".item .itemselected","color: #333399;","huiis");
	WApplication::styleSheet().addRule(".itemselected .itemselected","color: #FF0000;","huisis");

	setTitle("Menu test");

	root()->addNew<Wt::WText>("Test menu with 2 levels");

	auto stack = Wt::cpp14::make_unique<Wt::WStackedWidget>();
	stack_ = stack.get();
	menu_ = root()->addNew<Wt::WMenu>(stack_);
	root()->addWidget(std::move(stack));

	menu_->addItem("Menu1", Wt::cpp14::make_unique<Wt::WText>("Menu1 contents"));
	menu_->addItem("Menu2", Wt::cpp14::make_unique<Wt::WText>("Menu2 contents"));

	auto sm3 = Wt::cpp14::make_unique<Wt::WMenu>(stack_);
	auto sm3_ptr = sm3.get();
	menu_->addMenu("Menu3 - Sub", std::move(sm3));
	sm3_ptr->addItem("SM31", Wt::cpp14::make_unique<Wt::WText>("Sub Menu31 contents"));
	sm3_ptr->addItem("SM32", Wt::cpp14::make_unique<Wt::WText>("Sub Menu32 contents"));
	sm3_ptr->addItem("SM33", Wt::cpp14::make_unique<Wt::WText>("Sub Menu33 contents"));

	auto sm4 = Wt::cpp14::make_unique<Wt::WMenu>(stack_);
	auto sm4_ptr = sm4.get();
	menu_->addMenu("Menu4 - Sub", std::move(sm4));
	sm4_ptr->addItem("SM41", Wt::cpp14::make_unique<Wt::WText>("Sub Menu41 contents"));
	sm4_ptr->addItem("SM42", Wt::cpp14::make_unique<Wt::WText>("Sub Menu42 contents"));

	menu_->addItem("Menu5", Wt::cpp14::make_unique<Wt::WText>("Menu5 contents"));
	menu_->addItem("Menu6", Wt::cpp14::make_unique<Wt::WText>("Menu6 contents"));
}


int main(int argc, char **argv)
{
	return Wt::WRun(argc, argv, [](const Wt::WEnvironment &env) {
			return Wt::cpp14::make_unique<MenuApplication>(env);
			});
}
