#include <Wt/WApplication.h>
#include <Wt/WText.h>
#include <Wt/WBreak.h>
#include <Wt/WMenu.h>
#include <Wt/WMenuItem.h>
#include <Wt/WStackedWidget.h>


// ./helloMenu --docroot /tmp --http-listen 0.0.0.0

class MenuApplication : public Wt::WApplication
{
	public:
		MenuApplication(const Wt::WEnvironment& env);

	private:
		void menu1ItemSelected(Wt::WMenuItem* mi);
		void menu2ItemSelected(Wt::WMenuItem* mi);
		Wt::WMenu *menu_;
		Wt::WStackedWidget *stack_;

};


void MenuApplication::menu1ItemSelected(Wt::WMenuItem* mi)
{
	if (mi->menu())
	{
		// contains submenu -> select last selected from submenu or first
		int ci = mi->menu()->currentIndex();
		if (ci>=0)
		{
			mi->menu()->select(ci); // recursion handled in Wt
		}
		else if (!mi->menu()->items().empty())
		{
			mi->menu()->select(0); // recursion handled in Wt
		}
	}
}

void MenuApplication::menu2ItemSelected(Wt::WMenuItem* mi)
{
	if (mi->parentMenu() &&
			mi->parentMenu()->parentItem()
	   )
	{
		// called from submenu
		mi->parentMenu()->parentItem()->select(); // recursion handled Wt
	} 
}


MenuApplication::MenuApplication(const Wt::WEnvironment& env)
	: WApplication(env),
	menu_(nullptr),
	stack_(nullptr)
{
	WApplication::styleSheet().addRule(".item","color: #0000FF;","hui");
	WApplication::styleSheet().addRule(".itemselected","color: #FF0000;","huis");
	WApplication::styleSheet().addRule(".item .itemselected","color: #333399;","huiis");
	WApplication::styleSheet().addRule(".itemselected .itemselected","color: #FF0000;","huisis");

        auto fce_mis1 = ([this](Wt::WMenuItem* mm){
                        menu1ItemSelected(mm);
                        });
        auto fce_mis2 = ([this](Wt::WMenuItem* mm){
                        menu2ItemSelected(mm);
                        });

	setTitle("Menu test");

	root()->addNew<Wt::WText>("Test menu with 2 levels");
	root()->addNew<Wt::WBreak>();

	auto stack = Wt::cpp14::make_unique<Wt::WStackedWidget>();
	stack_ = stack.get();
	menu_ = root()->addNew<Wt::WMenu>(stack_);
	root()->addWidget(std::move(stack));
        menu_->itemSelected().connect(fce_mis1);

	menu_->addItem("Menu1", Wt::cpp14::make_unique<Wt::WText>("Menu1 contents"));
	menu_->addItem("Menu2", Wt::cpp14::make_unique<Wt::WText>("Menu2 contents"));

	auto sm3 = Wt::cpp14::make_unique<Wt::WMenu>(stack_);
	auto sm3_ptr = sm3.get();
	auto sm3i = menu_->addMenu("Menu3 - Sub", std::move(sm3));
	sm3i->setSelectable(true); 
	sm3_ptr->addItem("SM31", Wt::cpp14::make_unique<Wt::WText>("Sub Menu31 contents"));
	sm3_ptr->addItem("SM32", Wt::cpp14::make_unique<Wt::WText>("Sub Menu32 contents"));
	sm3_ptr->addItem("SM33", Wt::cpp14::make_unique<Wt::WText>("Sub Menu33 contents"));
        sm3_ptr->itemSelected().connect(fce_mis2);

	auto sm4 = Wt::cpp14::make_unique<Wt::WMenu>(stack_);
	auto sm4_ptr = sm4.get();
	auto sm4i = menu_->addMenu("Menu4 - Sub", std::move(sm4));
	sm4i->setSelectable(true); 
	sm4_ptr->addItem("SM41", Wt::cpp14::make_unique<Wt::WText>("Sub Menu41 contents"));
	sm4_ptr->addItem("SM42", Wt::cpp14::make_unique<Wt::WText>("Sub Menu42 contents"));
        sm4_ptr->itemSelected().connect(fce_mis2);

	menu_->addItem("Menu5", Wt::cpp14::make_unique<Wt::WText>("Menu5 contents"));
	menu_->addItem("Menu6", Wt::cpp14::make_unique<Wt::WText>("Menu6 contents"));
}


int main(int argc, char **argv)
{
	return Wt::WRun(argc, argv, [](const Wt::WEnvironment &env) {
			return Wt::cpp14::make_unique<MenuApplication>(env);
			});
}
