#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WWidget>
#include <Wt/WPushButton>
#include <Wt/WMessageBox>
#include <Wt/WStandardItemModel>
#include <Wt/WTableView>
#include <Wt/WBreak>

using namespace Wt;

class TestApplication : public Wt::WApplication
{
private:
  WContainerWidget   *rootContainer_;

public:
  TestApplication(const WEnvironment& env);
  
  void showFirstButton();
  void showDataTable();
};

TestApplication::TestApplication(const WEnvironment& env):
  WApplication(env),
  rootContainer_(NULL)
{
  rootContainer_ = new WContainerWidget(root());
  showFirstButton();
}

void TestApplication::showFirstButton()
{
  rootContainer_->clear();

  WPushButton* firstButton = new WPushButton("show the table view");
  firstButton->resize(WLength(200, WLength::Pixel), WLength(35, WLength::Pixel));
  firstButton->clicked().connect(this, &TestApplication::showDataTable);

  rootContainer_->addWidget(firstButton);
}

void TestApplication::showDataTable()
{
  rootContainer_->clear();

  //button
  WPushButton* secondButton = new WPushButton("close the table view");
  secondButton->resize(WLength(200, WLength::Pixel), WLength(35, WLength::Pixel));
  secondButton->clicked().connect(this, &TestApplication::showFirstButton);

  //table view
  WStandardItemModel* model = new WStandardItemModel();
  model->insertColumns(0, 4);

  model->setHeaderData(0, boost::any(std::string("column 0")));
  model->setHeaderData(1, boost::any(std::string("column 1")));
  model->setHeaderData(2, boost::any(std::string("column 2")));
  model->setHeaderData(3, boost::any(std::string("column 3")));

  model->insertRows(0, 4);
  for (int i=0; i<4; i++)
    for (int j=0; j<4; j++)
    {
      WString cellData("({1}, {2})");
      model->setData(model->index(i, j), boost::any(cellData.arg(i).arg(j))); 
    }

  WTableView* tableView = new WTableView();
  tableView->setModel(model);

  tableView->setColumnWidth(0, 100);
  tableView->setColumnWidth(1, 110);
  tableView->setColumnWidth(2, 120);
  tableView->setColumnWidth(3, 130);
  tableView->resize(WLength(500, WLength::Pixel), WLength(160, WLength::Pixel));

  //breaks
  WBreak* br1 = new WBreak();
  WBreak* br2 = new WBreak();

  //collect widgets
  rootContainer_->addWidget(secondButton);
  rootContainer_->addWidget(br1);
  rootContainer_->addWidget(br2);
  rootContainer_->addWidget(tableView);
}

WApplication *createApplication(const WEnvironment& env)
{
  return new TestApplication(env);
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, &createApplication);
}
