namespace
{
	class Painted 
		: public Wt::WPaintedWidget
	{
	public:
		Painted( Wt::WContainerWidget* parent = 0 )
			: Wt::WPaintedWidget( parent )
		{
		}
		virtual void paintEvent( Wt::WPaintDevice* paintDevice )
		{
			Wt::WPainter painter( paintDevice );
			painter.setPen( Wt::SolidLine );
			painter.drawRect( painter.window() );
			painter.restore();
		}
	};	

	class TestSVG
		: public Wt::WApplication
	{
	public:
		TestSVG( const Wt::WEnvironment& env )
			: Wt::WApplication( env )
		{
			auto p = new Painted( root() );
			p->setPositionScheme( Wt::Absolute );
			p->setOffsets( 0, Wt::Top );
			p->setOffsets( 0, Wt::Left );
			p->resize( 50, 10 );
			
			p = new Painted( root() );
			p->setPositionScheme( Wt::Absolute );
			p->setOffsets( 0, Wt::Top );
			p->setOffsets( 0, Wt::Left );
			p->resize( 100, 100 );
		}
	};
}
