/*
 * Copyright (C) 2008 Emweb bv, Herent, Belgium.
 *
 * See the LICENSE file for terms of use.
 */

#include <Wt/WApplication.h>
#include <Wt/WProgressBar.h>
#include <Wt/WFileUpload.h>
#include <Wt/WContainerWidget.h>
#include <Wt/WPushButton.h>

using namespace Wt;

class HelloApplication: public WApplication {
public:
    HelloApplication(const WEnvironment& env);

private:

    WPushButton *uploadButton;
    Wt::WFileUpload *fu;

    void greet();
    void fileUploaded();
};

HelloApplication::HelloApplication(const WEnvironment& env) :
        WApplication(env) {
    root()->addStyleClass("container");
    setTitle("Hello world");       // application title

    fu = root()->addNew<Wt::WFileUpload>();
    fu->setFileTextSize(50); // Set the maximum file size to 50 kB.
    fu->setProgressBar(new Wt::WProgressBar());
    fu->uploaded().connect(this, &HelloApplication::fileUploaded);
    // Provide a button to start uploading.
    uploadButton = root()->addNew< Wt::WPushButton >("Send");

    // Upload when the button is clicked.

    uploadButton->clicked().connect(this, &HelloApplication::greet);
}

void HelloApplication::greet() {
    fu->upload();
    uploadButton->disable();

}

void HelloApplication::fileUploaded() {

    std::cout << " yes " <<  fu->spoolFileName() << std::endl;

}

int main(int argc, char **argv) {
    return Wt::WRun(argc, argv, [](const Wt::WEnvironment &env) {

        return Wt::cpp14::make_unique<HelloApplication>(env);
    });
}
