#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WWidget>
#include <Wt/WPushButton>
#include <Wt/WMessageBox>
#include <Wt/WStandardItemModel>
#include <Wt/WTableView>
#include <Wt/WBreak>

using namespace Wt;

class TestApplication : public Wt::WApplication
{
private:
  WContainerWidget   *rootContainer_;

public:
  TestApplication(const WEnvironment& env);
  void showTableView();
};

TestApplication::TestApplication(const WEnvironment& env):
  WApplication(env),
  rootContainer_(NULL)
{
  rootContainer_ = new WContainerWidget(root());
  showTableView();
}

void TestApplication::showTableView()
{
  rootContainer_->clear();

  //table view
  WStandardItemModel* model = new WStandardItemModel();
  model->insertColumns(0, 5);

  model->setHeaderData(0, boost::any(std::string("column 0")));
  model->setHeaderData(1, boost::any(std::string("column 1")));
  model->setHeaderData(2, boost::any(std::string("column hidden")));
  model->setHeaderData(3, boost::any(std::string("column 3")));
  model->setHeaderData(4, boost::any(std::string("column 4")));

  model->insertRows(0, 4);
  for (int i=0; i<4; i++)
    for (int j=0; j<5; j++)
    {
      WString cellData("({1}, {2})");
      model->setData(model->index(i, j), boost::any(cellData.arg(i).arg(j))); 
    }

  WTableView* tableView = new WTableView();

  tableView->setSelectable(true);
  tableView->setSelectionMode(Wt::SingleSelection);

  tableView->setColumnHidden(2, true); //!!
  tableView->setRowHeaderCount(1); //!!

  tableView->setModel(model);

  tableView->setColumnWidth(0, 100);
  tableView->setColumnWidth(1, 100);
  //tableView->setColumnWidth(2, 110); --hidden
  tableView->setColumnWidth(3, 120);
  tableView->setColumnWidth(4, 130);
  tableView->resize(WLength(500, WLength::Pixel), WLength(160, WLength::Pixel));
  
  //breaks
  WBreak* br1 = new WBreak();
  WBreak* br2 = new WBreak();

  //collect widgets
  rootContainer_->addWidget(tableView);
}

WApplication *createApplication(const WEnvironment& env)
{
  return new TestApplication(env);
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, &createApplication);
}
