#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WWidget>
#include <Wt/WPushButton>
#include <Wt/WSelectionBox>
#include <Wt/WHBoxLayout>
#include <Wt/WBreak>
#include <Wt/WLabel>

using namespace Wt;

class TestApplication : public Wt::WApplication
{
private:
  WContainerWidget   *rootContainer_;

public:
  TestApplication(const WEnvironment& env);
  void showLayout();
};

TestApplication::TestApplication(const WEnvironment& env):
  WApplication(env),
  rootContainer_(NULL)
{
  rootContainer_ = new WContainerWidget(root());
  showLayout();
}

void TestApplication::showLayout()
{
  rootContainer_->clear();
  
  WHBoxLayout* layout = new WHBoxLayout();
  rootContainer_->setLayout(layout, Wt::AlignLeft);

  WSelectionBox* selectionBox = new WSelectionBox();
  selectionBox->resize(250, 300);
  layout->addWidget(selectionBox, 1, 0);

  WPushButton* firstButton = new WPushButton("first button");
  firstButton->setMaximumSize(100, 25);
  layout->addWidget(firstButton);
}

WApplication *createApplication(const WEnvironment& env)
{
  return new TestApplication(env);
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, &createApplication);
}
