#include <Wt/WApplication>
#include <Wt/WLogger>
#include <Wt/WAnchor>
#include <Wt/WIconPair>
#include <Wt/WGridLayout>
#include <Wt/WVBoxLayout>
#include <Wt/WCheckBox>
#include <Wt/WScrollArea>
#include <Wt/WText>
#include <Wt/WDialog>
#include <Wt/WPushButton>
#include <Wt/WBreak>
#include <Wt/WWidgetItem>
#include <Wt/WTabWidget>
#include <Wt/WContainerWidget>
#include <Wt/WEnvironment>

#include <string>

using namespace Wt;
using namespace std;

class test : public WApplication
{
public:
  test(const WEnvironment& env)
    : WApplication(env)
  { 
_grid = new WGridLayout(); 
_grid->setContentsMargins(10,10,10,10);

_scroll_area = new WScrollArea(); 
_scroll_area->resize( 300 , 400 ) ; 
_scroll_area->setMinimumSize( 300 , 400 ) ; 
_scroll_area->setScrollBarPolicy( WScrollArea::ScrollBarAsNeeded );
_scroll_area->setPositionScheme(Absolute);
_scroll_area->setMargin(10);

_hbox = new WVBoxLayout();

WContainerWidget * scrollContainer = new WContainerWidget(); 
_scroll_area->setWidget(scrollContainer );
scrollContainer->resize( WLength::Auto , WLength::Auto );
//scrollContainer->setMinimumSize(290, WLength::Auto );
scrollContainer->setLayout ( _hbox ) ;

 for (unsigned i = 0; i < 100; ++i) {
   WCheckBox *cb = new WCheckBox("Bla" + boost::lexical_cast<std::string>(i));
   _hbox->addWidget(cb);
 }

// up button -------------------------------------------------------
WIconPair *_up = new WIconPair( "icons/up_48.png","icons/up_48.png" );
 _up->setToolTip(WString::tr("recordlist.columns.up"));
 _up->icon1Clicked().connect(this, &test::doit);
// down button -------------------------------------------------------
WIconPair *_down = new WIconPair( "icons/down_48.png","icons/down_48.png" );
 _down->setToolTip(WString::tr("recordlist.columns.down"));
//----- up down container -------------------------------------------
WContainerWidget * upDownContainer = new WContainerWidget(); 
upDownContainer->addWidget(_up); 
upDownContainer->addWidget(new WBreak()); 
upDownContainer->addWidget(_down);

int row = 0 ; int column = 0 ; 
_grid->addWidget( _scroll_area , row , column , AlignTop | AlignLeft ) ; 
column++ ; 
_grid->addWidget( upDownContainer , row , column, AlignMiddle | AlignRight ) ;
column = 0 ; row++ ; 
 _grid->addWidget( new WContainerWidget() , row , column, 1 , 2 , AlignBottom | AlignCenter) ;
_grid->setRowStretch(0, 1 ) ; 
_grid->setRowStretch(1, 0 ) ;
_grid->setColumnStretch( 0 , 1 ) ; 
_grid->setColumnStretch( 1 , 0 ) ; 
//---
 root()->setLayout(_grid);
  }

  void doit() {
    static int index = 5;
    WLayoutItem *item = _hbox->itemAt(index);
    WWidget *w = ((WWidgetItem *)(item))->widget();
    _hbox->removeItem(item) ; 
    _hbox->insertWidget( index + 1 , w ) ; 

    ++index;
    // _scroll_area->refresh();
  }

private:
  WGridLayout *_grid;
  WScrollArea *_scroll_area;
  WVBoxLayout *_hbox;
};

WApplication *createApplication(const WEnvironment& env)
{
  return new test(env);
}

int main(int argc, char **argv)
{
 return WRun(argc, argv, &createApplication);
}
