
// includes (STL)
#include <algorithm>
#include <future>
#include <iostream>
#include <memory>
#include <thread>
#include <vector>
// includes (Wt)
#include <Wt/WContainerWidget.h>

using namespace Wt;

//!
//!
//!
void testUniqueness()
{
	static const size_t NumTasks = 100;
	static const size_t ObjectsPerTask = 100000;

	auto createTask = []()
	{
		std::vector<std::unique_ptr<Wt::WContainerWidget>> result;
		result.reserve(ObjectsPerTask);
		for (size_t i = 0; i < ObjectsPerTask; ++i)
		{
			result.emplace_back(std::make_unique<Wt::WContainerWidget>());
		}
		return result;
	};

	auto idTask = [](const std::vector<std::unique_ptr<Wt::WContainerWidget>>& ws, size_t taskId)
	{
		std::vector<std::string> result;
		result.reserve(ObjectsPerTask);
		for (const auto& w : ws)
		{
			result.emplace_back(w->id());
		}
		std::sort(std::begin(result), std::end(result));
		result.erase(std::unique(std::begin(result), std::end(result)), std::end(result));
		return result;
	};

	std::cout << "creating widgets ...\n";
	std::vector<std::future<std::vector<std::unique_ptr<Wt::WContainerWidget>>>> wfs;
	wfs.reserve(NumTasks);
	for (size_t i = 0; i < NumTasks; ++i)
	{
		wfs.emplace_back(std::async(std::launch::async, createTask));
	}
	for (const auto& f : wfs)
	{
		f.wait();
	}

	std::cout << "creating ids ...\n";
	std::vector<std::future<std::vector<std::string>>> idfs;
	idfs.reserve(NumTasks);
	for (size_t i = 0; i < NumTasks; ++i)
	{
		idfs.emplace_back(std::async(std::launch::async, idTask, wfs[i].get(), i));
	}
	for (const auto& f : idfs)
	{
		f.wait();
	}

	std::cout << "merging ids & removing duplicates ...\n\n";
	std::vector<std::string> ids;
	ids.reserve(NumTasks * ObjectsPerTask);
	for (size_t i = 0; i < NumTasks; ++i)
	{
		auto tmp = idfs[i].get();
		std::cout << "task #" << i << ": " << tmp.size() << " of " << ObjectsPerTask << " ids are unique\n";
		ids.insert(std::end(ids), std::make_move_iterator(std::begin(tmp)), std::make_move_iterator(std::end(tmp)));
	}
	std::sort(std::begin(ids), std::end(ids));
	ids.erase(std::unique(std::begin(ids), std::end(ids)), std::end(ids));

	std::cout << "\noverall: " << ids.size() << " of " << NumTasks * ObjectsPerTask << " ids are unique\n\n";
}

//!
//!
//!
int main(int argc, char** args)
{
	testUniqueness();

	return 0;
}
