#include <Wt/WApplication.h>
#include <Wt/WBootstrapTheme.h>
#include <Wt/WServer.h>

#include <Wt/WContainerWidget.h>
#include <Wt/WText.h>
#include <Wt/WVBoxLayout.h>
#include <Wt/WTabWidget.h>
#include <Wt/WTableView.h>
#include <Wt/WStandardItemModel.h>
#include <Wt/WStandardItem.h>

using namespace Wt;


// -----------------------------------------------------------------------------------
std::unique_ptr<WContainerWidget> buildTableViewTab()
{
    int rows = 6;
    int columns = 10;

    std::shared_ptr<WStandardItemModel> model = std::make_shared<WStandardItemModel>(rows, columns);

    for (int row = 0; row < rows; ++row)
    {
      for (int column = 0; column < columns; ++column)
      {
        auto item = std::make_unique<Wt::WStandardItem>();
        item->setText("Item " + std::to_string(row)
                      + ", " + std::to_string(column));
        model->setItem(row, column, std::move(item));
      }
    }

    auto listCont = std::make_unique<WContainerWidget>();

    auto listVLayout = listCont->setLayout(std::make_unique<WVBoxLayout>());
    listVLayout->setContentsMargins(0, 0, 0, 35);
    listVLayout->setSpacing(2);

    auto demoTable = listVLayout->addWidget(std::make_unique<WTableView>(), 1);
    demoTable->setAlternatingRowColors(true);
    demoTable->setSelectionMode(SelectionMode::Single);
    demoTable->setColumnResizeEnabled(true);
    demoTable->setModel(model);

    listVLayout->addWidget(std::make_unique<WText>("Lower Line"));

    return listCont;
}



// -----------------------------------------------------------------------------------
std::unique_ptr<WApplication> createHelloApplication(const WEnvironment &env)
{
    auto app = std::make_unique<Wt::WApplication>(env);

    auto theme = std::make_shared<Wt::WBootstrapTheme>();
    theme->setVersion(Wt::BootstrapVersion::v3);
    app->setTheme(theme);

    WVBoxLayout *mainLayout = app->root()->setLayout(std::make_unique<WVBoxLayout>());

    // this will work, when WTabWidget part below is commented out
    //    mainLayout->addWidget(buildTableViewTab(), 1);

    auto tabWidget = mainLayout->addWidget(std::make_unique<WTabWidget>(), 1);
    tabWidget->addTab(buildTableViewTab(), "WTableView Problem");
    tabWidget->addTab(std::make_unique<WText>("Demo Content"), "Demo Empty");

    return app;
}


// -----------------------------------------------------------------------------------
int main(int argc, char *argv[])
{
    try
    {
        WServer server(argc, argv, WTHTTP_CONFIGURATION);

        server.addEntryPoint(EntryPointType::Application,
                             std::bind(&createHelloApplication, std::placeholders::_1));

        if (server.start())
        {
          int sig = WServer::waitForShutdown();

          std::cerr << "*** Shutdown (signal = " << sig << ")" << std::endl;
          server.stop();

          if (sig == 1) // SIGHUP
            WServer::restart(argc, argv, environ);

          return 0;
        }
    }
    catch (WServer::Exception &e)
    {
        std::cerr << "*** Server Exception: " << e.what() << std::endl;
    }
    catch (std::exception &e)
    {
        std::cerr << "*** Std Exception: " << e.what() << std::endl;
    }
}
