#include	<Wt/WApplication.h>
#include	<Wt/WLabel.h>
#include	<Wt/WContainerWidget.h>
#include	<Wt/WPushButton.h>
#include	<Wt/WVBoxLayout.h>

namespace
{
	class SizeAwareContainer : public Wt::WContainerWidget
	{
		Wt::WLabel* mySizeIndicator;
	public:
		SizeAwareContainer()
		: Wt::WContainerWidget()
		{
			setLayoutSizeAware( true );
			mySizeIndicator = addNew< Wt::WLabel >();
		}
		void layoutSizeChanged( int width, int height ) override
		{
			mySizeIndicator->setText( "Height = " + std::to_string( height ) );
		}
	};

	Wt::WString GetHugeToolTipText()
	{
		Wt::WString text;
		for( int i = 0; i < 50; i++ )
			text += "Line " + std::to_string( i ) + "<br/>";
		return text;
	}

	class TestHugeToolTip
		: public Wt::WApplication
	{
	public:
		TestHugeToolTip( const Wt::WEnvironment& env )
			: Wt::WApplication( env )
		{			
			auto l = root()->setLayout< Wt::WVBoxLayout >( std::make_unique< Wt::WVBoxLayout >() );

			auto c =  l->addWidget( std::make_unique< SizeAwareContainer >() );
			c->setOverflow( Wt::Overflow::Hidden );

			auto b1 = c->addNew< Wt::WPushButton >( "Check my tooltip" );
			b1->setToolTip( GetHugeToolTipText(), Wt::TextFormat::XHTML );

			auto b2 = c->addNew< Wt::WPushButton >( "Check my tooltip" );
			b2->setPositionScheme( Wt::PositionScheme::Absolute );
			b2->setOffsets( 200, Wt::Side::Left | Wt::Side::Top );
			b2->setToolTip( GetHugeToolTipText(), Wt::TextFormat::XHTML );
		}
	};
}