#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WServer>
#include <Wt/WTemplate>
#include <Wt/WText>

class Test_App : public Wt::WApplication
{
	private:
		
		void create_home( void )
		{
			setTitle( "UTF8-Test" );
			
			Wt::WTemplate* t = new Wt::WTemplate( Wt::WString::tr("umlaut"), root() );
			t->addFunction( "tr", &Wt::WTemplate::Functions::tr );
			
			t->bindString( "u1", "äöü" );
			t->bindString( "u2", Wt::WString::fromUTF8("äöü") );
			t->bindString( "u3", Wt::WString::tr( "uml" ) );
			t->bindWidget( "u4", new Wt::WText( Wt::WString::fromUTF8("äöü") ) );
			t->bindString( "u5", L"äöü" );
		}
		
	public:
		
		Test_App( Wt::WEnvironment const& env )
			: Wt::WApplication(env)
		{
			Wt::WString::setDefaultEncoding( Wt::UTF8 );
			
			std::cout << "Server locale: " << this->locale().name() << std::endl;
			std::cout << "User locale:   " << env.locale().name() << std::endl;
			std::cout << "Set server locale to de" << std::endl;
			
			messageResourceBundle().use( "content" );
			
			create_home();
		}
};

Wt::WApplication *create_application( Wt::WEnvironment const& env )
{ return new Test_App(env); }

int main(int argc, char **argv)
{
	try
	{
		Wt::WServer server( argv[0] );
		
		static char* argv[]={"Wt_Test","--http-address=0.0.0.0","--http-port=8080","--deploy-path=/","--docroot=.;/resources"};
		argc = 6;
		
		server.setServerConfiguration( argc, argv, WTHTTP_CONFIGURATION );
		server.addEntryPoint( Wt::Application, create_application, "", "" );
		
		if( server.start() )
		{
			Wt::WServer::waitForShutdown();
			server.stop();			
		}
	}
	catch( Wt::WServer::Exception& e )
	{
		std::cerr << "WServer-Exception: " << e.what() << std::endl;
	}
	catch( std::exception& e )
	{
		std::cerr << "Exception: " << e.what() << std::endl;
	}
}
