#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WPainter>
#include <Wt/WPaintDevice>
#include <Wt/WPaintedWidget>
#include <Wt/WFont>

class MyPaintedWidget : public Wt::WPaintedWidget
{
public:
        MyPaintedWidget(Wt::WContainerWidget *parent = 0) : Wt::WPaintedWidget(parent)
        {
                resize(200, 200);
        }
protected:
        void paintEvent(Wt::WPaintDevice *paintDevice)
        {
                Wt::WPainter painter(paintDevice);
                Wt::WFont mono;
                mono.setFamily(Wt::WFont::Monospace, "Courier New");
		mono.setSize(0.2);
                painter.setFont(mono);
		painter.scale(50,50);
		painter.drawText(2, 1, 1, 0.22, Wt::AlignMiddle | Wt::AlignCenter, Wt::TextSingleLine, "ABC");
        }
};


class PainterApplication : public Wt:: WApplication
{
public:
	PainterApplication(const Wt::WEnvironment& env);
};

PainterApplication::PainterApplication(const Wt::WEnvironment &env) : Wt::WApplication(env)
{
	Wt::WContainerWidget *container = new Wt::WContainerWidget(root());
	new MyPaintedWidget(container);
}

Wt::WApplication *createApplication(const Wt::WEnvironment& env)
{
	return new PainterApplication(env);
}

int main(int argc, char **argv)
{
	return Wt::WRun(argc, argv, &createApplication);
}
