#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WServer>

#include <Wt/WContainerWidget>
#include <Wt/WPushButton>

#include <unistd.h>

using namespace std;
using namespace Wt;

class MyApplication : public WApplication {
public:
  MyApplication(const WEnvironment &env)
    : WApplication(env),
      t_(0)
  {
    WPushButton *b = new WPushButton("sleep", root());
    b->clicked().connect(std::bind(&MyApplication::do_sleep, this));
    t_ = new WText("", root());
  }

  void do_sleep();

private:
  WText *t_;
};

void MyApplication::do_sleep()
{
  std::cout << "start of 3 second sleep" << std::endl;
  ::sleep(3);
  t_->setText("Slept 3 seconds");
  doJavaScript("console.log(\"Slept 3 seconds!\");");
  std::cout << "end of 3 second sleep" << std::endl;
}

WApplication *createApplication(const WEnvironment &env)
{
  return new MyApplication(env);
}

int main(int argc, char *argv[])
{
  return WRun(argc, argv, &createApplication);
}
