#ifndef CurveEdit_H
#define CurveEdit_H

// sdk
#include "../../SDK/TVNG.h"
#include "../../SDK/PlatformIndependent/SceneManagement/AnimationCurve.h"
#include <Wt/Chart/WCartesianChart>
#include <Wt/WPainter>
#include <Wt/WEvent>

namespace Wt
{
	class WStandardItemModel;
}

/**
 * \brief A simple 2D curve editor
 */

class CurveEdit : public Wt::Chart::WCartesianChart
{
public:
	CurveEdit(const std::string& label);
	~CurveEdit();

	// returns the curve
	const TVNG::FloatAnimationCurve& GetCurve() const { return curve_ ; }

	// sets the curve
	void SetCurve( const TVNG::FloatAnimationCurvePtr& curve ) ;

	// provide an accessor for the signal
	Wt::Signal<>& Changed() { return changed_; }

	// @inherited
	virtual void paint(Wt::WPainter& painter, const Wt::WRectF& rectangle) const;

private:

	Wt::WFont labelFont_;
	Wt::Signal<> changed_;
	std::string label_;
	Wt::WStandardItemModel* model_;
	int selectedRowIndex_;

	double lastEmitTime_;
	TVNG::FloatAnimationCurve curve_;

	void UpdateCurve();
	bool SamePoints(const TVNG::Vector2f& p1, const TVNG::Vector2f& p2);

	// signals
	void MouseWentDown(const Wt::WMouseEvent& e);
	void MouseDragged(const Wt::WMouseEvent& e);
	void DoubleClicked(const Wt::WMouseEvent& e);
	void Clicked(const Wt::WMouseEvent& e);
	void KeyWentUp(const Wt::WKeyEvent& e);
} ;


#endif // HEADER