/*
 * Copyright (C) 2010 Emweb bvba, Kessel-Lo, Belgium.
 *
 * See the LICENSE file for terms of use.
 */

#include "PlannerCalendar.h" 
#include "CalendarCell.h" 
#include "Entry.h" 
#include <Wt/WWidget.h>
#include <memory>

using namespace Wt;

PlannerCalendar::PlannerCalendar(dbo::ptr<UserAccount> user)
  : WCalendar(),
    user_(user)
{
  setStyleClass(styleClass() + " calendar");
  //setSelectionMode(SelectionMode::None);
}

WWidget* PlannerCalendar::renderCell(WWidget* widget, const WDate& date)
{
  if (!widget)
  {
    widget = new CalendarCell();
  }

  CalendarCell* cc = (CalendarCell*)widget;
  cc->update(user_, date);

  cc->cellWasModified().connect(this, &PlannerCalendar::cellModified);
  cc->cellWasModified().connect(this ,&PlannerCalendar::onlyForDebuging);

  //calendarModified_.emit(WString("tom")); //TODO hardcoded
 // cc->cellWasModified().connect(this, &PlannerCalendar::calendarWasModified);
  return cc;
}

void PlannerCalendar::cellModified(const Wt::WString &str)
{
  calendarWasModified()(str);
}
