ChangePasswordWidget::ChangePasswordWidget(bool aReqCurrentPsw)
	: WDialog(tr("ChangePassword.Title")),
	_reqCurrentPsw(aReqCurrentPsw)
{
	setMovable(false);

	// Contents of dialog => XML defined
	WTemplate *formTemplate = contents()->addWidget(std::make_unique<WTemplate>());
	formTemplate->addFunction("id", &WTemplate::Functions::id);
	formTemplate->addFunction("tr", &WTemplate::Functions::tr);
	formTemplate->setCondition("if-reqCurrentPsw", aReqCurrentPsw);
	formTemplate->setTemplateText(tr("ChangePasswordWidget"));

	_currentPassword = formTemplate->bindWidget("currentPassword", std::make_unique<WLineEdit>());
	_currentPassword->setEchoMode(EchoMode::Password);
	_currentPassword->setFocus();

	_newPassword = formTemplate->bindWidget("newPassword", std::make_unique<WLineEdit>());
	_newPassword->setEchoMode(EchoMode::Password);
	if (aReqCurrentPsw == false)
		_newPassword->setFocus();
	
	_confirmPassword = formTemplate->bindWidget("confirmPassword", std::make_unique<WLineEdit>());
	_confirmPassword->setEchoMode(EchoMode::Password);
	_confirmPassword->enterPressed().connect(this, &WDialog::accept);

	// Footer of dialog
	WPushButton *okButton = footer()->addWidget(std::make_unique<WPushButton>(tr("ChangePassword.UpdateButton")));
	okButton->clicked().connect(this, &WDialog::accept);
	okButton->setStyleClass("btn btn-primary");

	WPushButton *cancelButton = footer()->addWidget(std::make_unique<WPushButton>(tr("ChangePassword.CancelButton")));
	cancelButton->clicked().connect(this, &WDialog::reject);
	cancelButton->setStyleClass("btn btn-danger");

	contents()->escapePressed().connect(this, &WDialog::reject);
}

ChangePasswordWidget::~ChangePasswordWidget()
{

}

bool ChangePasswordWidget::changePassword()
{
	while (true) {
		switch (exec()) {
		case DialogCode::Accepted:
			// do something
			break;
		case DialogCode::Rejected:
			return false;
		}
	}
}