/*
 * Copyright (C) 2008 Emweb bvba, Kessel-Lo, Belgium.
 *
 * See the LICENSE file for terms of use.
 */
#include <iostream>
#include <boost/lexical_cast.hpp>

#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WLineEdit>
#include <Wt/WPushButton>
#include <Wt/WTemplate>
#include <Wt/WString>

using namespace Wt;

class TestApplication : public WApplication {
public:
  TestApplication(const WEnvironment& env)
    : WApplication(env) {

    messageResourceBundle().use("1");

    WTemplate *text = new WTemplate(Wt::WString::tr("hello"));
    text->bindString("test", "<i>");
    root()->addWidget(text);
  }
};

WApplication *createApplication(const WEnvironment& env)
{
  WApplication *app = new TestApplication(env);
  return app;
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, &createApplication);
}
