
// Initialize model and WTableView
Wt::WStandardItemModel* model =  new WStandardItemModel(container);
model->insertColumns(0, headers_.size());
Wt::WTableView* table = new WTableView(container);
table->setModel(model_);
table_->setColumnResizeEnabled(true);
table_->setColumnAlignment(0, AlignCenter);
table_->setHeaderAlignment(0, AlignCenter);
table_->setAlternatingRowColors(false);
table_->setRowHeaderCount(1);
table_->setSelectionMode(ExtendedSelection);
table_->setMaximumSize(table_->width(),
                         WLength(TABLE_HEIGHT, WLength::Unit::Pixel));

// Update function triggered by postAll  on the server
void updateTableView() {
  int row = 0;
  for (const auto& item : dataToBeInserted) {
    //... DO SOME STUFF...
    model->insertRow(row++);
    for(int col = 0; col < item.columns(); col++) {
      model->setData(row, col, item.value(col));
      model_->setData(row, col, item.styleclass, StyleClassRole);
    }
  }
  int rowCount = model_->rowCount();
  if (rowCount > MAX_NUMBER_OF_ROWS) {
    model_->removeRows(MAX_NUMBER_OF_ROWS, rowCount - MAX_NUMBER_OF_ROWS);
  }
}