#include <Wt/WApplication.h>
#include <Wt/WBootstrapTheme.h>
#include <Wt/WContainerWidget.h>
#include <Wt/WDateEdit.h>
#include <Wt/WDialog.h>
#include <Wt/WPanel.h>
#include <Wt/WText.h>

#include <memory>

// set to 1 to test with a dialog instead
#define DIALOG 0

int main(int argc, char *argv[])
{
  return Wt::WRun(argc, argv, [](const Wt::WEnvironment &env) {
    auto app = std::make_unique<Wt::WApplication>(env);

    auto theme = std::make_shared<Wt::WBootstrapTheme>();
    theme->setVersion(Wt::BootstrapVersion::v3);
    app->setTheme(theme);

#if DIALOG
    Wt::WDialog *dialog = app->addChild(std::make_unique<Wt::WDialog>());
    dialog->resize(300, 150);
    dialog->setTitleBarEnabled(true);
    dialog->titleBar()->addNew<Wt::WText>("Titlebar");
    dialog->contents()->addNew<Wt::WDateEdit>();

    dialog->show();
#else
    Wt::WPanel *panel = app->root()->addNew<Wt::WPanel>();
    panel->setTitle(Wt::utf8("Titlebar"));
    auto containerPtr = std::make_unique<Wt::WContainerWidget>();
    auto container = containerPtr.get();
    panel->setCentralWidget(std::move(containerPtr));

    container->addNew<Wt::WDateEdit>();
#endif

    return app;
  });
}
