
#include <Wt/WApplication>
#include <Wt/WText>
#include <Wt/WStringListModel>
#include <Wt/WTableView>
#include <Wt/WPushButton>
#include <Wt/WContainerWidget>

class HelloApp : public Wt::WApplication
{
public:
    HelloApp(const Wt::WEnvironment& env):
        Wt::WApplication(env)
    {
        Wt::WTableView* view = new Wt::WTableView(root());
        Wt::WStringListModel* model = new Wt::WStringListModel(this);
        model->addString("foo");
        model->addString("bar");
        model->addString("foo bar");
        view->setModel(model);
        view->setEditTriggers(Wt::WAbstractItemView::SingleClicked);
        view->resize(770, 250);
        view->setColumnWidth(1, 100);
        view->setRowHeaderCount(1);
        view->setAlternatingRowColors(true);
        Wt::WPushButton* button = new Wt::WPushButton("Close editors", root());
        button->clicked().connect(boost::bind(&Wt::WTableView::closeEditors, view, /*saveData*/ true));
    }
};

Wt::WApplication *createApplication(const Wt::WEnvironment& env)
{
    return new HelloApp(env);
}

int main(int argc, char **argv)
{
    return Wt::WRun(argc, argv, &createApplication);
}

