#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WSlider>
#include <Wt/WGridLayout>

using namespace Wt;

class HelloApplication : public WApplication
{
public:
  HelloApplication(const WEnvironment& env);

};

HelloApplication::HelloApplication(const WEnvironment& env)
  : WApplication(env)
{
  WSlider *sliderHorizontal = new WSlider(Horizontal);
  sliderHorizontal->setRange(0,100);
  sliderHorizontal->setValue(10);
  sliderHorizontal->setTickInterval(5);
  sliderHorizontal->setTickPosition(WSlider::TicksBothSides);

  WSlider *sliderVertical = new WSlider(Vertical);
  sliderVertical->setRange(0,100);
  sliderVertical->setValue(10);
  sliderVertical->setTickInterval(5);
  sliderVertical->setTickPosition(WSlider::TicksBothSides);

  WGridLayout *gridLayout = new WGridLayout(root());
  gridLayout->addWidget(sliderHorizontal,1,1);
  gridLayout->addWidget(sliderVertical,3,3);
  root()->setLayout(gridLayout);
}

WApplication *createApplication(const WEnvironment& env)
{
  return new HelloApplication(env);
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, &createApplication);
}

