﻿#ifndef _MIR_DEFINES_H_
#define _MIR_DEFINES_H_
/*
 * Copyright (c) 2011,
 * Technical University Of Gdansk,
 * Faculty of Electronics, Telecommunications and Informatics,
 * Multimedia Systems Department
 * and/or its affiliates. All rights reserved.
 */

#ifndef DATABASEMODULE_ADMIN_ID
#define DATABASEMODULE_ADMIN_ID 9000000000000000000LL
#endif

#ifndef MAX_SLIDER_VALUE
#define MAX_SLIDER_VALUE 2147483647
#endif

#ifndef MIR_PATH_TO_WWW_DIR
/// Wszystko w formacie UNIXOWYM
#define MIR_PATH_TO_WWW_DIR "/var/www"
#endif
#ifndef MIR_FULLPATH_TO_URIS
#define MIR_FULLPATH_TO_URIS_FILE "/opt/musicRobot/uris"
#endif
#ifndef MIR_FULLPATH_TO_MRS_PROP
#define MIR_FULLPATH_TO_MRS_PROP "/etc/MusicRobotService/MusicRobotSvc.properties"
#endif
#ifndef MIR_PATH_TO_DEST_MP3
#define MIR_PATH_TO_DEST_MP3 "/var/www/music"
#endif
#ifndef MIR_FULLPATH_TO_MESS_RES_BUNDLE
#define MIR_FULLPATH_TO_MESS_RES_BUNDLE "/opt/musicRobot/SyNaTPGmessages"
#endif

#define MIR_REGEXP_LOGIN "[a-zA-Z]+[a-zA-Z0-9]+"
#define MIR_REGEXP_EMAIL "[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}"

#define MIR_URI_FILE_NAMED_MUTEX                "smu_nmut"
#define MIR_GTT_NUMBER_NAMED_MUTEX              "smg_nmut"
#define MIR_NUM_OF_USERS_LOGGED_NAMED_MUTEX     "sms_nmut"

#define MIR_NUM_OF_USERS_LOGGED_SMO             "smnl_smo"
#define MIR_NUM_OF_GTT_SMO                      "smng_smo"

/* Formaty eksportu */
#define MIR_CSV_FORMAT 0
#define MIR_HTM_FORMAT 1
#define MIR_PDF_FORMAT 2

#define MIR_MAX_PDF_FIELDS 24
/**
 * Użytkownik nie aktywny
 */
#define MIR_NOTACTIVE             0x0000000000000000LL

/**
 * Użytkownik aktywny
 */
#define MIR_ACTIVE                0x8000000000000000LL

/**
 * Użytkownik ma prawo do sciągania plików audio
 */
#define MIR_MUSIC_FILE_DOWNLOADER 0x0000000000000008LL

/**
 * Użytkownik ma prawo do operacji na Muzycznym Robocie
 */
#define MIR_MUSIC_ROBOT_OPERATOR  0x0000000000000004LL

/**
 * Użytkownik ma prawo do operacji na plikach
 */
#define MIR_MUSIC_FILE_OPERATOR   0x0000000000000002LL

/**
 * Użytkownik ma prawo do operacji na użytkownikach
 */
#define MIR_USER_OPERATOR         0x0000000000000001LL

#endif //_MIR_DEFINES_H_
