﻿#ifndef _MIR_MR_MUSICROBOTAPP_H_
#define _MIR_MR_MUSICROBOTAPP_H_
/*
 * Copyright (c) 2011,
 * Technical University Of Gdansk,
 * Faculty of Electronics, Telecommunications and Informatics,
 * Multimedia Systems Department
 * and/or its affiliates. All rights reserved.
 */

#include <Wt/WApplication>
#include <Wt/WWidget>
#include <Wt/WAnchor>
#include <Wt/WText>
#include <Wt/WProgressBar>
#include <Wt/WPushButton>
#include <Wt/WTimer>
#include <Wt/WTextArea>
#include <Wt/WAnchor>
#include <Wt/WMessageBox>
#include <Wt/WLabel>
#include <Wt/WLineEdit>
#include <Wt/WMenuItem>
#include <Wt/Dbo/Dbo>
#include <Wt/Dbo/backend/Firebird>
#include <Wt/WMediaPlayer>

#include <boost/ptr_container/ptr_vector.hpp>
#include <boost/ptr_container/ptr_map.hpp>
#include <boost/thread/mutex.hpp>
#include <boost/thread.hpp>

#include <string>

#include "controls/mir_sp_controlswidget.h"

namespace SyNaT
{
  namespace MIR
  {
    namespace SP
    {
      using namespace std;
      using namespace Wt;
      namespace db = Wt::Dbo;

      /**
       * A <code>SyNaTPGApp</code> is main application class which is instantiated
       * per user session.
       *
       * @author  Łukasz Matuszewski
       * @version $Id: mir_sp_synatpgapp.h 586 2011-10-23 17:14:50Z lmatusz $
       */
      class SyNaTPGApp : public WApplication
      {
//          friend void LoginPage::loginPage(void);
//          friend void LoginPage::m_slt_wpbLogin(void);
//          friend void MainPage::mainPage(void);
//          friend void SettingsPage::m_slt_wpbSave(void);
//          friend void SettingsPage::getMusicServers(void);
//          friend void SettingsPage::settingsPage(void);
//          friend void StatusPage::m_slt_wpbStart(void);
//          friend void StatusPage::statusPage(void);
//          friend void StatusPage::m_slt_wpbStop(void);
	      protected:

          WStackedWidget															 *m_contentsStack_;

          WPushButton																	 *m_localeChanger_en;
          WPushButton																	 *m_localeChanger_pl;
        public:

          void slt_menuItemSelected(WMenuItem *mi);

          void slt_localeAboutToBeChangedToPl();

          void slt_localeAboutToBeChangedToEn();


          void                                          slt_appQuitAndRedirect();
          /**
           * @returns how many users are logged (sessions started and not ended). NOTE:
           * the number is stored in shared between processes memory object.
           */
//          unsigned int                                  num_of_sessions();
//
//          /**
//           * Increases by 1 the number which indicates number of logged users (sessions
//           * started and not ended). NOTE:
//           * the number is stored in shared between processes memory object.
//           */
//          void                                          inc_num_of_sessions();
//
//          /**
//           * Decreases by 1 the number which indicates number of logged users (sessions
//           * started and not ended). NOTE:
//           * the number is stored in shared between processes memory object.
//           */
//          void                                          dec_num_of_sessions();

          void                                          createMenuAndContents(WTemplate *table, bool activation = false);

                                                        SyNaTPGApp(const WEnvironment& env);
          
          virtual                                      ~SyNaTPGApp();

          string                                        m_last_used_internal_path;

          string                                        m_saved_app_internalpath;

          enum LastUsedAppControl
          {
            ExplorerControls,
            ExplorerControlsFullSongDesc,
            TagExplorerControls,
            HelpControls,
            HelpControlsContact,
            LoginControls,
            MusicRobotControls,
            SearchEngineControls,
            SettingsControlsExport,
            SettingsControlsMyAccount,
            UserControlsAdd,
            UserControlsList,
						GenreRecognitionControls
          };

          LastUsedAppControl                            m_last_used_app_control;

          string                 m_internal_path_to_select;


          //WText                                        *m_wtappmessage;
      }; // class SyNaTPGApp

    } // namespace SP
  } // namespace MIR
} // namespace SyNaT

#endif //_MIR_MR_MUSICROBOTAPP_H_
