#ifndef _MIR_SP_EXPLORER_H_
#define _MIR_SP_EXPLORER_H_
/*
 * Copyright (c) 2011,
 * Technical University Of Gdansk,
 * Faculty of Electronics, Telecommunications and Informatics,
 * Multimedia Systems Department
 * and/or its affiliates. All rights reserved.
 */

#include <Wt/WMenu>
#include <Wt/WLineEdit>
#include <Wt/WTableView>
#include <Wt/Dbo/Dbo>
#include <Wt/Dbo/QueryModel>
#include <Wt/WWidget>
#include <Wt/WEvent>
#include <Wt/Dbo/backend/Firebird>
#include <Wt/WLabel>
#include <Wt/WCheckBox>
#include <Wt/WComboBox>
#include <Wt/WTextArea>
#include <Wt/WImage>
#include <Wt/WSuggestionPopup>
#include <Wt/WTableCell>
#include <Wt/WContainerWidget>
#include <Wt/WTableView>

#include <string>

#include "controls/mir_sp_controlswidget.h"
#include "mir_sp_synatpgapp.h"

namespace SyNaT
{
  namespace MIR
  {
    namespace SP
    {
      using namespace Wt;
      namespace db = Wt::Dbo;

      class ExplorerControls : public ControlsWidget
      {
        public:
          std::string                                       m_viewname;
          WTableView								   *m_wtv;
          string                                            m_whereSql;
          string                                            m_showOnlySelectedWhereSql;
          SyNaTPGApp                                       *m_app;

          ExplorerControls(SyNaTPGApp *app, WMenu *mainmenu, const string cssClass = "", const bool forceCssClass = "")
            : ControlsWidget(false, cssClass, forceCssClass), m_mainmenu(mainmenu), m_app(app)
            , m_selected(0)
          {
			  //this->addWidget(this->create_explorer_controls());
          }

          virtual ~ExplorerControls()
          {
          }

          WWidget                                           *create_explorer_controls();

        protected:
           WMenu                                            *m_mainmenu;
           int                                               m_rows;
           int                                               m_selected;
           int                                               m_num_of_rows_filtered;
           int                                               m_audio_duration_in_ms;

           WPushButton                                      *m_wpbTagsRefresh;
           WPushButton                                      *m_wpbTagSave;
           WLabel                                           *m_wlblTagName;
           WLineEdit                                        *m_wleTagName;
           WLabel                                           *m_wlblTagValue;
           WLineEdit                                        *m_wleTagValue;
           WSuggestionPopup                                 *m_wspTagName;
           WContainerWidget                                 *m_tagsCell;
           std::vector<string>                               m_tagsOfAudioFile;

           WLabel                                           *m_wlblArtistName;
           WLabel                                           *m_wlblArtistNameMsg;
           WLineEdit                                        *m_wleArtistName;
           WLabel                                           *m_wlblTitleName;
           WLabel                                           *m_wlblTitleNameMsg;
           WLineEdit                                        *m_wleTitleName;
           WLabel                                           *m_wlblGenre;
           WLabel                                           *m_wlblGenreMsg;
           WLineEdit                                        *m_wleGenre;
           WComboBox                                        *m_wcbGenre;
           WCheckBox                                        *m_wcbxGenre;
           WLabel                                           *m_wlblAlbumName;
           WLabel                                           *m_wlblAlbumNameMsg;
           WLineEdit                                        *m_wleAlbumName;
           WLabel                                           *m_wlblYearOfRecording;
           WLabel                                           *m_wlblYearOfRecordingMsg;
           WLineEdit                                        *m_wleYearOfRecording;
           WLabel                                           *m_wlblTrackNumber;
           WLabel                                           *m_wlblTrackNumberMsg;
           WLineEdit                                        *m_wleTrackNumber;
           WLabel                                           *m_wlblComment;
           WLabel                                           *m_wlblCommentMsg;
           WTextArea                                        *m_wtaComment;
           WLabel                                           *m_wlblHistoricalDetails;
           WLabel                                           *m_wlblHistoricalDetailsMsg;
           WTextArea                                        *m_wtaHistoricalDetails;
           WLabel                                           *m_wlblMessage;
           void                                              populateAndSetwcbGenre(const string &gatunek);

      };
    }
  }
}

#endif /* _MIR_SP_EXPLORER_H_ */
