//#include "utils/mir_sha1.h"

#include <Wt/WApplication>
#include <Wt/WText>
#include <Wt/WProgressBar>
#include <Wt/WPushButton>
#include <Wt/WTimer>
#include <Wt/WTextArea>
#include <Wt/WAnchor>
#include <Wt/WImage>
#include <Wt/WMessageBox>
#include <Wt/WLabel>
#include <Wt/WContainerWidget>
#include <Wt/WStackedWidget>
#include <Wt/WLogger>
#include <Wt/WWidget>
#include <Wt/WTemplate>
#include <Wt/WEnvironment>
#include <Wt/WLoadingIndicator>
#include <Wt/WLocale>

#include <sstream>

#include <boost/foreach.hpp>
#include <boost/regex.hpp>
#include <boost/ptr_container/ptr_vector.hpp>
#include <boost/ptr_container/ptr_map.hpp>
#include <boost/thread/mutex.hpp>
#include <boost/filesystem.hpp>
#include <boost/interprocess/shared_memory_object.hpp>
#include <boost/interprocess/mapped_region.hpp>
#include <boost/interprocess/sync/named_mutex.hpp>
#include <boost/interprocess/sync/scoped_lock.hpp>
#include <boost/scoped_ptr.hpp>
#include <boost/bind.hpp>

#include "utils/mir_trkeys.h"
#include "utils/mir_defines.h"
#include "utils/mir_cssclasses.h"
#include "utils/mir_internalpaths.h"
#include "mir_sp_synatpgapp.h"

#include "utils/mir_cssconsts.h"
#include "controls/mir_sp_controlswidget.h"
#include "controls/mir_sp_explorercontrols.h"

namespace SyNaT
{
  namespace MIR 
  {
    namespace SP
    {

      using namespace std;
      using namespace Wt;
      using namespace IBPP;
      using namespace boost::filesystem;
      using namespace boost::interprocess;

      SyNaTPGApp::SyNaTPGApp(const WEnvironment& env)
        : WApplication(env)
      {
        this->messageResourceBundle().use("I:/!Kingston_old/sound.eti.pg.gda.pl/SYNAT/ProjAndLibs/trunk/SyNaTPG2NewTest/messresbundle/SyNaTPGmessages");

        this->setCssTheme("polished");

        //this->useStyleSheet("css/reset.css");
        //this->useStyleSheet("/css/wt/wt.css");
        //this->useStyleSheet("/css/wt/wt_ie.css", "lt IE 7");
        //this->useStyleSheet("style/everywidget.css");
        //this->useStyleSheet("style/dragdrop.css");
        //this->useStyleSheet("style/combostyle.css");
        //this->useStyleSheet("style/menu.css");
        this->useStyleSheet(WApplication::resourcesUrl() + "jPlayer/skin/jplayer.blue.monday.css");
				this->useStyleSheet("style/style.css");

        this->loadingIndicator()->widget()->setStyleClass(this->loadingIndicator()->widget()->styleClass().toUTF8() + " " MIR_STRINGIFY(MIR_CSS_LOADING_INDICATOR));
        this->setTitle(WString::tr(MIR_SYNAT_BROWSER_TITLE));


        WTemplate *layoutTemplate = new WTemplate(this->root());
				layoutTemplate->setTemplateText("  <div class=\"main-container\">														\
																																																		\
																							${header}																							\
																																																		\
																							<div class=\"headerMenu\">														\
																								<div class=\"pd40\">																\
																									<div class=\"dropdownmenu\" style=\"clear:both;\">\
																										${dropdownmenu}																	\
																									</div>																						\
																								</div>																							\
																							</div>																								\
																							<div class=\"content\">																\
																								<div class=\"pd40\">																\
																									${contentsstack}																	\
																								</div>																							\
																							</div>																								\
																						</div>																									\
																						${footer}																								");	
		layoutTemplate->setId("main");

        this->createMenuAndContents(layoutTemplate, true);
      }

      void SyNaTPGApp::createMenuAndContents(WTemplate *layoutTemplate, bool activation)
      {
        this->m_contentsStack_ = new WStackedWidget();
        WAnimation fade(WAnimation::Fade, WAnimation::Linear, 250);
        this->m_contentsStack_->setTransitionAnimation(fade);
        // Show scrollbars when needed ...
        //this->m_contentsStack_->setOverflow(WContainerWidget::OverflowAuto);
        this->m_contentsStack_->setWidth(WLength(100, WLength::Percentage));
        // ... and work around a bug in IE (see setOverflow() documentation)
        //this->m_contentsStack_->setPositionScheme(Static);
        this->m_contentsStack_->setStyleClass(MIR_STRCAT3(MIR_CSS_CONTENTS," ",MIR_CSS_MAIN_PAGE));
        /*
         * Setup the menu (and submenus)
         */
        WMenu *menu = new WMenu(this->m_contentsStack_, this->root());
        menu->setStyleClass(MIR_STRINGIFY(MIR_CSS_MENU_DROPDOWN) " mainmenu");
        menu->setInternalPathEnabled();
        WMenuItem *mi, *miLoginOrAct;
        // tutaj tworzę wszystkie dostępne menu, ale schowane (tzn. WMenuItem->hide())

        menu->itemSelected().connect(this, &SyNaTPGApp::slt_menuItemSelected);

        miLoginOrAct = menu->addItem(WString::tr(MIR_MENU_EXPLORER), new SyNaT::MIR::SP::ExplorerControls(this, menu, MIR_STRINGIFY(MIR_CSS_MARGIN_FOR_ANIM)));
		miLoginOrAct->setPathComponent(MIR_IPATH_EXPLORER); // Strona główna po zalogowaniu
		//miLoginOrAct->select();
        //mi->hide();

		mi = menu->addItem(WString::tr(MIR_MENU_GENRERECOGNITION), new WText("genre recognition"));
		mi->setPathComponent(MIR_IPATH_GENRE_RECOGNITION); // Strona główna po zalogowaniu
		mi->select();

		mi = menu->addItem(WString::tr(MIR_MENU_HELP), new WText("help"));

        this->m_localeChanger_en = new WPushButton();
        this->m_localeChanger_pl = new WPushButton();

        WTemplate *headerTemplate = new WTemplate();
				headerTemplate->setTemplateText("<div class=\"headerGlow\">	\
																					${anchor_synat}						\
																					${button_en}							\
																					${button_pl}							\
																				 </div>");
				headerTemplate->setStyleClass("header");
				WAnchor *anch = new WAnchor();
				anch->setAttributeValue("style", "margin-top:22px; display:inline-block; margin-left:40px");
				WImage *img = new WImage(WLink("/wt/style/img/logo.png"), WString::fromUTF8("SYNAT"));
				anch->addWidget(img);
				headerTemplate->bindWidget("anchor_synat", anch);
				headerTemplate->bindWidget("button_en", this->m_localeChanger_en);
				headerTemplate->bindWidget("button_pl", this->m_localeChanger_pl);

				string locale_pl, locale_en;
				if (this->locale().name().find("pl") >= 0)
				{
					locale_pl = "active";
				}
				else
				{
					locale_en = "active";
				}

				WTemplate *footerTemplate = new WTemplate();

				footerTemplate->setTemplateText("");
				footerTemplate->setStyleClass("footer");

				layoutTemplate->bindWidget("header", headerTemplate);
				layoutTemplate->bindWidget("dropdownmenu", menu);
				layoutTemplate->bindWidget("footer", footerTemplate);
				layoutTemplate->bindWidget("contentsstack", this->m_contentsStack_);

        this->m_localeChanger_en->setStyleClass("lang_button lang_button_en Wt-btn " + locale_en);
        this->m_localeChanger_en->clicked().connect(this, &SyNaTPGApp::slt_localeAboutToBeChangedToEn);
        this->m_localeChanger_pl->setStyleClass("lang_button lang_button_pl Wt-btn " + locale_pl);
        this->m_localeChanger_pl->clicked().connect(this, &SyNaTPGApp::slt_localeAboutToBeChangedToPl);
		
			}

      void SyNaTPGApp::slt_appQuitAndRedirect()
      {
        this->quit();
        this->redirect("http://localhost:8080/wt/SyNaTPG.wt");
      }
      

      SyNaTPGApp::~SyNaTPGApp()
      {

      }

      void SyNaTPGApp::slt_localeAboutToBeChangedToEn()
      {
				this->m_localeChanger_pl->setStyleClass("lang_button lang_button_pl Wt-btn");
				this->m_localeChanger_en->setStyleClass("lang_button lang_button_en Wt-btn active");
				this->setLocale(WLocale("en"));
     }

      void SyNaTPGApp::slt_localeAboutToBeChangedToPl()
      {
				this->m_localeChanger_en->setStyleClass("lang_button lang_button_en Wt-btn");
				this->m_localeChanger_pl->setStyleClass("lang_button lang_button_pl Wt-btn active");
				this->setLocale(WLocale("pl"));
      }

      void SyNaTPGApp::slt_menuItemSelected(WMenuItem *mi)
      {
        WContainerWidget *contents = dynamic_cast<WContainerWidget *>(mi->contents());
        string internalPath = this->internalPath();
        string pathComponent = mi->pathComponent();
		if (internalPath == "/" MIR_IPATH_EXPLORER/* "/"*/)

        {

          SyNaT::MIR::SP::ExplorerControls *ec = dynamic_cast<SyNaT::MIR::SP::ExplorerControls *>(contents->widget(0));
            try
            {
              ec->clear();
              ec->addWidget(ec->create_explorer_controls());

              if (this->m_last_used_app_control != SyNaTPGApp::ExplorerControls)
              {
                this->m_saved_app_internalpath = this->m_last_used_internal_path;
              }
              this->m_last_used_app_control = SyNaTPGApp::ExplorerControls;
            }
            catch(std::exception &e)
            {
              this->log("error") << e.what();
            }

        this->m_last_used_internal_path = this->internalPath();

        return;
      }
	}

    } // namespace SP
  } // namespace MIR
} // namespace SyNaT
