#include <Wt/WApplication.h>
#include <Wt/WBootstrap5Theme.h>

#include <Wt/WContainerWidget.h>
#include <Wt/WPushButton.h>
#include <Wt/WDialog.h>
#include <Wt/WLineEdit.h>
#include <Wt/WOverlayLoadingIndicator.h>
#include <Wt/WRegExpValidator.h>
#include <Wt/WPopupMenu.h>

using namespace Wt;


// -----------------------------------------------------------------------------------
std::unique_ptr<WApplication> createHelloApplication(const WEnvironment &env)
{
    // This global locale setting causes the long delays and the crash in WPopupMenu::addItem
    std::locale::global(std::locale("en_us.utf8"));

    auto app = std::make_unique<WApplication>(env);

    app->setLoadingIndicator(std::make_unique<WOverlayLoadingIndicator>());

    auto theme = std::make_shared<WBootstrap5Theme>();
    app->setTheme(theme);

    auto showDlgBt = app->root()->addNew<WPushButton>("Show Input-Dialog");
    showDlgBt->setInline(false);

    showDlgBt->clicked().connect([=]
    {
        Wt::log("Debug") << "Time-In";

        auto dialog = WApplication::instance()->addChild(std::make_unique<WDialog>("Input Dialog with Umlauts"));

        auto lineInput = dialog->contents()->addNew<WLineEdit>("Text with Umlauts öäüÖÄÜß");

        auto validator = std::make_shared<Wt::WRegExpValidator>("[a-zA-ZäÄöÖüÜß0-9]{1}[a-zA-ZäÄöÖüÜß@\' 0-9.,_-]{0,30}");
        lineInput->setValidator(validator);

        auto okBt = dialog->footer()->addNew<WPushButton>("OK");
        okBt->clicked().connect([=] { dialog->accept(); });

        dialog->show();

        Wt::log("Debug") << "Time-Out";
    });

    auto showMenuBt = app->root()->addNew<WPushButton>("Show WPopupMenu");
    showMenuBt->setInline(false);

    auto popup = std::make_unique<WPopupMenu>();
    popup->addItem("Item 1 with Chinese letters 中文 (Zhōngwén); 汉语, 漢語");    // Crash here
    popup->addItem("Item 2 with Chinese letters 中文 (Zhōngwén); 汉语, 漢語");
    popup->addItem("Item 3 with Chinese letters 中文 (Zhōngwén); 汉语, 漢語");
    popup->addItem("Item 4 with Chinese letters 中文 (Zhōngwén); 汉语, 漢語");

    showMenuBt->setMenu(std::move(popup));


    return app;
}


// -----------------------------------------------------------------------------------
int main(int argc, char *argv[])
{
    return Wt::WRun(argc, argv, &createHelloApplication);
}
