#include "session.h"

#include "Wt/Auth/AuthService"
#include "Wt/Auth/HashFunction"
#include "Wt/Auth/PasswordService"
#include "Wt/Auth/PasswordStrengthValidator"
#include "Wt/Auth/PasswordVerifier"
/*#include "Wt/Auth/GoogleService"
#include "Wt/Auth/Dbo/AuthInfo"
#include "Wt/Auth/Dbo/UserDatabase"
*/

using namespace Wt;

namespace {
    Auth::AuthService myAuthService;
    Auth::PasswordService myPasswordService(myAuthService);
}

const Auth::AuthService& Session::auth()
{
  return myAuthService;
}

const Auth::AbstractPasswordService& Session::passwordAuth()
{
  return myPasswordService;
}

Auth::AbstractUserDatabase& Session::users()
{
  return *users_;
}

void Session::configureAuth()
{
  myAuthService.setAuthTokensEnabled(true, "prodmoncookie");
  //myAuthService.setEmailVerificationEnabled(false);

  Auth::PasswordVerifier *verifier = new Auth::PasswordVerifier();
  verifier->addHashFunction(new Auth::BCryptHashFunction(7));

#ifdef HAVE_CRYPT
  // We want to still support users registered in the pre - Wt::Auth
  // version of the hangman example
  verifier->addHashFunction(new UnixCryptHashFunction());
#endif

  myPasswordService.setVerifier(verifier);
  myPasswordService.setStrengthValidator(new Auth::PasswordStrengthValidator());

  myPasswordService.setAttemptThrottlingEnabled(false);
}

Session::Session()
{
}

