#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WServer>
#include <Wt/WText>

#include <boost/property_tree/ptree.hpp>
#include <boost/property_tree/json_parser.hpp>

using namespace Wt;

class MyApplication : public WApplication
{
public:
	MyApplication(const WEnvironment& env)
    : WApplication(env)
    {
		WText *text = new WText();
		text->setText("Hello!");
		root()->addWidget(text);
    }
};

WApplication *createApplication(const WEnvironment& env)
{
  /*
   * You could read information from the environment to decide whether
   * the user has permission to start a new application
   */
  return new MyApplication(env);
}

// Note: this function is never called
void crash_me()
{
    boost::property_tree::ptree pt;

    // Uncommenting the following line causes problems
    boost::property_tree::read_json("any-path", pt);
}

int main(int argc, char **argv)
{
	// Create user interface
	WServer server(argc, argv, WTHTTP_CONFIGURATION);
	server.addEntryPoint(Wt::Application, createApplication);

	if (server.start())
	{
		int sig = WServer::waitForShutdown();
		std::cerr << "Shutting down: (signal = " << sig << ")" << std::endl;
		server.stop();
	}
}

