#include <memory>

#include <Wt/WContainerWidget.h>
#include <Wt/WEnvironment.h>
#include <Wt/WApplication.h>
#include <Wt/WString.h>
#include <Wt/WTemplate.h>
#include <Wt/WWidget.h>

class Home : public Wt::WContainerWidget
{
private:
	Wt::WApplication* _root;
public:
	Home(Wt::WApplication* root)
		: _root(root),
		  Wt::WContainerWidget()
	{
		// Carrega os CSSs
		_root->useStyleSheet("Sedna/css/normalize.min.css");
		_root->useStyleSheet("Sedna/css/bootstrap.min.css");
		_root->useStyleSheet("Sedna/css/jquery.fancybox.css");
		_root->useStyleSheet("Sedna/css/flexslider.css");
		_root->useStyleSheet("Sedna/css/queries.css");
		_root->useStyleSheet("Sedna/css/etline-font.css");
		_root->useStyleSheet("Sedna/bower_components/animate.css/animate.min.css");
		_root->useStyleSheet("Sedna/css/styles.css");
		_root->useStyleSheet("http://maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css");
		this->setStyleClass("pulse2");
		this->setStyleClass("hero");
		this->setStyleClass("navigation");
		this->setStyleClass("fixed");
		this->setStyleClass("header");
		this->setStyleClass("down-arrow");
		this->setStyleClass("intro");
		this->setStyleClass("features");
		this->setStyleClass("features-extra");
		this->setStyleClass("hero-strip");
		this->setStyleClass("blog-intro");
		this->setStyleClass("blog");
		this->setStyleClass("testimonial-slider");
		this->setStyleClass("sign-up");
		this->setStyleClass("to-top");
		this->setStyleClass("footer");

		this->addWidget(std::make_unique<Wt::WTemplate>(tr("test-form")));

		// Carrega os JS
		_root->requireJQuery("http://ajax.googleapis.com/ajax/libs/jquery/1.11.2/jquery.min.js");
		//_root->require("Sedna/js/vendor/jquery-1.11.2.min.js");
		_root->require("Sedna/bower_components/retina.js/dist/retina.js");
		_root->require("Sedna/bower_components/classie/classie.js");
		_root->require("Sedna/bower_components/jquery-waypoints/lib/jquery.waypoints.min.js");
		_root->require("Sedna/js/jquery.fancybox.pack.js");
		_root->require("Sedna/js/vendor/bootstrap.min.js");
		_root->require("Sedna/js/jquery.flexslider-min.js");
		_root->require("Sedna/js/vendor/modernizr-2.8.3-respond-1.4.2.min.js");
		_root->require("Sedna/js/scripts.js");
	}
};

class FyscoSiteInstitucional : public Wt::WApplication
{
public:
	FyscoSiteInstitucional(const Wt::WEnvironment& env)
		: Wt::WApplication(env)
	{
		std::unique_ptr<Wt::WContainerWidget> layout(std::make_unique<Wt::WContainerWidget>());
		messageResourceBundle().use(this->appRoot() + "template");

		Home *home = root()->addWidget(std::make_unique<Home>(this));
	}
};

std::unique_ptr<Wt::WApplication> createApplication(const Wt::WEnvironment& env)
{
	return std::make_unique<FyscoSiteInstitucional>(env);
}

int main(int argc, char** argv)
{
	return Wt::WRun(argc, argv, &createApplication);
}