#include "Wt/WConfig.h"
#include "Wt/WApplication.h"
#include "Wt/WText.h"
#include "Wt/WStandardItem.h"
#include "Wt/WStandardItemModel.h"
#include "Wt/Chart/WCartesianChart.h"
#include "Wt/Chart/WDataSeries.h"


class TestApplication : public Wt::WApplication
{
    TestApplication(const Wt::WEnvironment& env) : Wt::WApplication(env){

        setTitle("Minimal working example Cartesian Chart");
        root()->addNew<Wt::WText>("You are in the test app");

        std::shared_ptr<Wt::WStandardItemModel> model = std::make_shared<Wt::WStandardItemModel>(10,2);
        for (int i=0;i<10;++i){
            auto item = std::make_unique<Wt::WStandardItem>();
            item->setData(i,Wt::ItemDataRole::User);
            model->setItem(i,0,std::move(item));
            auto item2 = std::make_unique<Wt::WStandardItem>();
            item2->setData(i+2,Wt::ItemDataRole::User);
            model->setItem(i,1,std::move(item2));
        }

        auto chart = root()->addNew<Wt::Chart::WCartesianChart>();
        chart->setModel(model);
        chart->setXSeriesColumn(0);

        auto series = std::make_unique<Wt::Chart::WDataSeries>(1,Wt::Chart::SeriesType::Bar);
        chart->addSeries(std::move(series));
    }
};

int main(int argc, char **argv)
{
    return Wt::WRun(argc, argv, [=](const Wt::WEnvironment& env){return std::make_unique<TestApplication>(env);}));
}
