#ifndef _TESTCASE_WT_WTEXTEDIT_IN_WTEMPLATE_H_
#define _TESTCASE_WT_WTEXTEDIT_IN_WTEMPLATE_H_


#include <Wt/WContainerWidget.h>
#include <Wt/WStandardItemModel.h>
#include <Wt/WSelectionBox.h>
#include <Wt/WTemplate.h>
#include <Wt/WTextEdit.h>
#include <Wt/WText.h>
#include <Wt/WLineEdit.h>
#include <Wt/WPushButton.h>
#include <Wt/WString.h>

namespace TestCase
{
    struct DataClass;
    class TestWidget;

class SetupWidget : public Wt::WContainerWidget
{
public:
    SetupWidget ();
    ~SetupWidget();

private:
    void createLayout();
    void createDataModel(int rows);

    std::shared_ptr<Wt::WStandardItemModel> modelData;
    Wt::WSelectionBox *sb_DataSelect;

    Wt::WSpinBox *spin_testVersion;

    TestWidget *testWidget;
};


struct DataClass
{
    Wt::WString title;
    Wt::WString text;
};

class TestWidget : public Wt::WContainerWidget
{
public:
    TestWidget();
    ~TestWidget();

    void setData(const DataClass& inData);
    void setTestVersion(int version);

private:
    int testVersion;

    void createLayout();
    void createEdit();
    void toggleEdit();
    void setEditValues();

    DataClass data;

    Wt::WText *txt_Title, *txt_Data;
    Wt::WTemplate *tmpl_Layout;
    Wt::WTemplate *tmpl_Edit;

    Wt::WLineEdit *le_Title;
    Wt::WTextEdit *editor;

    Wt::WPushButton *btn_ToggleEdit;
};


} // end namespace
#endif

