#include "TestCase_WTextEdit.h"

#include <Wt/WContainerWidget.h>
#include <Wt/WStandardItemModel.h>
#include <Wt/WStandardItem.h>
#include <Wt/WSelectionBox.h>
#include <Wt/WSpinBox.h>
#include <Wt/WTemplate.h>
#include <Wt/WTextEdit.h>
#include <Wt/WText.h>
#include <Wt/WPanel.h>
#include <Wt/WLabel.h>
#include <Wt/WLineEdit.h>
#include <Wt/WPushButton.h>
#include <Wt/WString.h>

namespace TestCase
{

/*********************************************
 * SetupWidget
 * ******************************************/

SetupWidget::SetupWidget()
{
    createLayout();
    createDataModel(5);
}

SetupWidget::~SetupWidget()
{}

void SetupWidget::createLayout()
{
    addNew<Wt::WLabel>("DataSelector");
    sb_DataSelect = addNew<Wt::WSelectionBox>();

    addNew<Wt::WLabel>("TestVersion-Selector");
    spin_testVersion = addNew<Wt::WSpinBox>();
    spin_testVersion->setValue(1);
    spin_testVersion->setMinimum(1);
    spin_testVersion->setMaximum(3);
    

    Wt::WPanel *testPanel = addNew<Wt::WPanel>();
    testPanel->setTitle("TestWidget");

    testWidget = testPanel->setCentralWidget(
        std::make_unique<TestWidget>()
    );

    sb_DataSelect->activated().connect([this](int index){
        this->testWidget->setData(
            Wt::cpp17::any_cast<DataClass>(
                this->modelData->data(
                    index, 0, Wt::ItemDataRole::User
                )
            )
        );
    });

    spin_testVersion->valueChanged().connect(testWidget, &TestWidget::setTestVersion);

}

void SetupWidget::createDataModel(int rows)
{
    modelData = std::make_shared<Wt::WStandardItemModel>();
    sb_DataSelect->setModel(modelData);

    DataClass data;

    Wt::WString titleString("Title Nr: {1}");
    Wt::WString dataString("<p>DataString</p><p>For Item #{1}</p>");

    std::unique_ptr<Wt::WStandardItem> item;
    for(int i = 0; i < rows; i++)
    {
        data.title = Wt::WString(titleString).arg(i);
        data.text = Wt::WString(dataString).arg(i);

        item = std::make_unique<Wt::WStandardItem>();
        item->setText(data.title);
        item->setData(data);

        modelData->appendRow(std::move(item));
    }
}


/*********************************************
 * TestWidget
 * ******************************************/

TestWidget::TestWidget()
    : tmpl_Edit(nullptr), testVersion(1)
{
    createLayout();
    data.text = "InitText";
    data.title = "InitTitle";
    setData(data);
}

TestWidget::~TestWidget()
{}

void TestWidget::setData(const DataClass& inData)
{
    data = inData;

    txt_Title->setText(data.title);
    txt_Data->setText(data.text);

    switch (testVersion)
    {
    case 1:
        {
            if(tmpl_Edit)
            {
                setEditValues();
                if(btn_ToggleEdit->text() == "Hide")
                    toggleEdit();
            }
        }
        break;

    case 2:
    case 3:
        {
            if(tmpl_Edit)
            {
                setEditValues();
            }
        }
        break;
    
    default:
        break;
    }

}

void TestWidget::setTestVersion(int version)
{
    testVersion = version;
}

void TestWidget::createLayout()
{
    txt_Title = addNew<Wt::WText>();

    tmpl_Layout = addNew<Wt::WTemplate>(
        Wt::WString("${textData}")
    );

    txt_Data = tmpl_Layout->bindNew<Wt::WText>("textData");

    btn_ToggleEdit = addNew<Wt::WPushButton>("Edit");
    btn_ToggleEdit->clicked().connect(this, &TestWidget::toggleEdit);
}

void TestWidget::createEdit()
{
    Wt::WString templateText = "<label>Title</label>\n";
    templateText += "${le_Title}\n";
    templateText += "<label>Text</label>\n${editor}";

    tmpl_Edit = addNew<Wt::WTemplate>( templateText );

    le_Title = tmpl_Edit->bindNew<Wt::WLineEdit>("le_Title");
    editor = tmpl_Edit->bindNew<Wt::WTextEdit>("editor");
}

void TestWidget::toggleEdit()
{
    if(btn_ToggleEdit->text() == "Edit")
    {
        if(!tmpl_Edit)
        {
            createEdit();
            setEditValues();
        } else
        {
            tmpl_Edit->setHidden(false);
        }
    
        switch(testVersion)
        {
            case 3:
                setEditValues();
                
            default:
                break;
        }

        btn_ToggleEdit->setText("Hide");
    }else
    {
        tmpl_Edit->setHidden(true);
        btn_ToggleEdit->setText("Edit");
    }
}

void TestWidget::setEditValues()
{
    le_Title->setText(data.title);
    editor->setText(data.text);
}


} // end namespace