/*
 * Testcase
 *
 * Author: Harm Claeys
 *
 * Compile for debugging:
 * g++ -std=c++14 -O0 -g3 -Wall -Wextra -c -fmessage-length=0 -o WImage.o WImage.cpp
 *
 * Build dynamically:
 * g++ -s -Wl,--gc-sections -o WImage WImage.o -lwthttp -lwt
 *
 * Run with:
 * ./testcase --docroot /usr/share/Wt --approot . --http-address 0.0.0.0 --http-port 8080
 *
 */

#include <Wt/WApplication.h>
#include <Wt/WContainerWidget.h>
#include <Wt/WImage.h>

class testcase : public Wt::WApplication {

	public:
		testcase(const Wt::WEnvironment& env) : WApplication(env) {

			setTitle("Connected");

			root()->addNew<Wt::WImage>("resources/ajax-loading.gif");

		}

};

int main(int argc, char **argv) {

	return Wt::WRun(argc, argv, [](const Wt::WEnvironment &env) { return std::make_unique<testcase>(env); });

}
