//
// Created by Rakesh on 23/11/2023.
//

#include "containermodel.h"

#include <boost/json/parse.hpp>
#include <log/NanoLog.h>
#include <Wt/WModelIndex.h>

using wirepulse::model::ContainerModel;

using std::operator""sv;

ContainerModel::ContainerModel( const std::vector<std::string>& output )
{
  models.reserve( output.size() );
  for ( const auto& line : output ) models.emplace_back( line );
}

std::any ContainerModel::data( const Wt::WModelIndex& index, Wt::ItemDataRole role ) const
{
  LOG_INFO << "Retrieving data for row: " << index.row() << "; column: " << index.column();
  if ( index.row() >= models.size() || index.column() >= 5 ) return {};
  auto& model = models[index.row()];
  switch ( index.column() )
  {
  case 0:
    return model.id;
  case 1:
    return model.name;
  case 2:
    return model.image;
  case 3:
    return model.created;
  case 4:
    return model.uptime;
  }

  return Wt::cpp17::any{};
}

std::any ContainerModel::headerData( int section, Wt::Orientation orientation, Wt::ItemDataRole ) const
{
  LOG_INFO << "Retrieving header name for column: " << section;
  if ( orientation != Wt::Orientation::Horizontal ) return {};

  switch ( section )
  {
  case 0:
    return Wt::WString{ "ID" };
  case 1:
    return Wt::WString{ "Name" };
  case 2:
    return Wt::WString{ "Image" };
  case 3:
    return Wt::WString{ "Created At" };
  case 4:
    return Wt::WString{ "Uptime" };
  }

  return Wt::cpp17::any{};
}

Wt::WModelIndex ContainerModel::index( int row, int column, const Wt::WModelIndex& parent ) const
{
  LOG_INFO << "Creating index for row: " << row << "; column: " << column;
  return createIndex( row, column, nullptr );
  // return Wt::WModelIndex();
}

void ContainerModel::add( const std::string& line )
{
  if ( models.empty() ) models.reserve( 16 );
  models.emplace_back( line );
}

ContainerModel::Model::Model( const std::string& line )
{
  auto value = boost::json::parse( line );
  auto& obj = value.get_object();

  if ( obj.contains( "ID"sv ) ) id = Wt::WString::fromUTF8( obj["ID"sv].get_string().c_str() );
  if ( obj.contains( "Image"sv ) ) image = Wt::WString::fromUTF8( obj["Image"sv].get_string().c_str() );
  if ( obj.contains( "CreatedAt"sv ) ) created = Wt::WString::fromUTF8( obj["CreatedAt"sv].get_string().c_str() );
  if ( obj.contains( "RunningFor"sv ) ) uptime = Wt::WString::fromUTF8( obj["RunningFor"sv].get_string().c_str() );
  if ( obj.contains( "State"sv ) ) state = Wt::WString::fromUTF8( obj["State"sv].get_string().c_str() );
  if ( obj.contains( "Ports"sv ) ) ports = Wt::WString::fromUTF8( obj["Ports"sv].get_string().c_str() );
  if ( obj.contains( "Names"sv ) ) name = Wt::WString::fromUTF8( obj["Names"sv].get_string().c_str() );
}