//
// Created by Rakesh on 23/11/2023.
//

#pragma once

#include <vector>

#include <Wt/WAbstractItemModel.h>

namespace wirepulse::model
{
  struct ContainerModel : Wt::WAbstractItemModel
  {
    struct Model
    {
      explicit Model( const std::string& line );
      Model( const Model& ) = delete;
      Model& operator=( const Model& ) = delete;
      Model( Model&& ) = default;
      Model& operator=( Model&& ) = default;

      Wt::WString id;
      Wt::WString image;
      Wt::WString created;
      Wt::WString uptime;
      Wt::WString state;
      Wt::WString ports;
      Wt::WString name;
    };

    explicit ContainerModel( const std::vector<std::string>& output );

    ContainerModel() = default;
    ContainerModel( const ContainerModel& ) = delete;
    ContainerModel& operator=( const ContainerModel& ) = delete;
    ContainerModel( ContainerModel&& ) = delete;
    ContainerModel& operator=( ContainerModel&& ) = delete;

    inline int columnCount( const Wt::WModelIndex& parent ) const override { return 5; }
    inline int rowCount( const Wt::WModelIndex& parent ) const override { return static_cast<int>( models.size() ); }
    inline Wt::WModelIndex parent( const Wt::WModelIndex& index ) const override { return {}; }
    std::any data( const Wt::WModelIndex& index, Wt::ItemDataRole role ) const override;
    std::any headerData( int section, Wt::Orientation orientation, Wt::ItemDataRole role ) const override;
    Wt::WModelIndex index( int row, int column, const Wt::WModelIndex& parent ) const override;

    void add( const std::string& line );

    std::vector<Model> models;
  };
}