    73	/* * * * * * * * * * * * * * * * * * * * * * * * * * */
    74	
    75	class DateDelegate
    76	: public Wt::WItemDelegate
    77	{
    78	  public:
    79	
    80	    ~DateDelegate()
    81	    {
    82	      std::cout << __FILE__ << ":" << __LINE__ << " " << std::endl;
    83	    }
    84	
    85	    std::unique_ptr< Wt::WWidget > createEditor
    86	    (
    87	     const Wt::WModelIndex & _index,
    88	     Wt::WFlags< Wt::ViewItemRenderFlag > _flags
    89	    ) const;
    90	
    91	    virtual Wt::cpp17::any editState( Wt::WWidget *editor, const Wt::WModelIndex &index ) const override;
    92	    void setEditState( Wt::WWidget * _editor, const Wt::WModelIndex & _index, const Wt::cpp17::any & _value ) const;
    93	    void setModelData ( const Wt::cpp17::any & _editState, Wt::WAbstractItemModel * _model, const Wt::WModelIndex & _index ) const;
    94	
    95	    void doCloseEditor( Wt::WDateEdit * _dateEdit, bool save ) const;
    96	    void doTabAction( Wt::WKeyEvent _keyEvent ) const;
    97	
    98	    mutable Wt::WDateEdit * m_dateEdit = nullptr;
    99	
   100	}; // endclass DateDelegate
   101	
   102	std::unique_ptr< Wt::WWidget >
   103	DateDelegate::
   104	createEditor
   105	(
   106	  const Wt::WModelIndex & _index,
   107	  Wt::WFlags< Wt::ViewItemRenderFlag > _flags
   108	) const
   109	{
   110	#ifndef NEVER
   111	  std::cout << __FILE__ << ":" << __LINE__
   112	    << " DateDelegate::createEditor()"
   113	    << " r:" << _index.row()
   114	    << " c:" << _index.column()
   115	    << std::endl;
   116	#endif
   117	
   118	  /*
   119	  ** The editor is placed in to a container for layout
   120	  **  management
   121	  **
   122	  */
   123	  auto retVal = std::make_unique< Wt::WContainerWidget >();
   124	#ifndef NEVER
   125	  retVal-> setSelectable( true );
   126	
   127	  /*
   128	  ** Get the date from the string value
   129	  **
   130	  */
   131	  auto date =
   132	    Wt::WDate::fromString
   133	    (
   134	     Wt::asString( _index.data( Wt::ItemDataRole::Edit ) ),
   135	     GCW::CFG::date_format()
   136	    );
   137	
   138	  /*
   139	  ** Build an editor
   140	  **
   141	  ** Hitting the 'enter' key or the 'esc' key closes the editor
   142	  **
   143	  */
   144	  auto dateEdit = std::make_unique< Wt::WDateEdit >();
   145	  m_dateEdit = dateEdit.get();
   146	  dateEdit-> setFormat( GCW::CFG::date_format() );
   147	  dateEdit-> setDate( date );
   148	  dateEdit-> enterPressed  ().connect( [&](){ doCloseEditor( dateEdit.get(), true  ); });
   149	  dateEdit-> escapePressed ().connect( [&](){ doCloseEditor( dateEdit.get(), false ); });
   150	  dateEdit-> keyWentDown   ().connect( [&]( Wt::WKeyEvent _keyEvent ){ doTabAction( _keyEvent ); });
   151	
   152	  /*
   153	  ** Stuff it in to the layout
   154	  **
   155	  */
   156	  retVal-> setLayout( std::make_unique< Wt::WHBoxLayout >() );
   157	  retVal-> layout()-> setContentsMargins( 1,1,1,1 );
   158	  retVal-> layout()-> addWidget( std::move( dateEdit ) );
   159	#endif
   160	
   161	  std::cout << __FILE__ << ":" << __LINE__ << " " << std::endl;
   162	
   163	  return retVal;
   164	
   165	} // endstd::unique_ptr< Wt::WWidget > DateDelegate::createEditor
   166	
   167	void
   168	DateDelegate::
   169	doCloseEditor( Wt::WDateEdit * _dateEdit, bool save ) const
   170	{
   171	#ifndef NEVER
   172	  std::cout << __FILE__ << ":" << __LINE__ << " DateDelegate::doCloseEditor()" << std::endl;
   173	#endif
   174	
   175	  closeEditor().emit( _dateEdit, save );
   176	
   177	} // endvoid DateDelegate::doCloseEditor( Wt::WDateEdit * _dateEdit, bool save ) const
   178	
   179	void
   180	DateDelegate::
   181	doTabAction( Wt::WKeyEvent _keyEvent ) const
   182	{
   183	#ifndef NEVER
   184	  std::cout << __FILE__ << ":" << __LINE__ << " DateDelegate::doTabAction()" << std::endl;
   185	#endif
   186	
   187	}
   188	
   189	Wt::cpp17::any
   190	DateDelegate::
   191	editState( Wt::WWidget * _editor, const Wt::WModelIndex & _index ) const
   192	{
   193	  auto cw = dynamic_cast< Wt::WContainerWidget* >( _editor );
   194	
   195	  auto de = dynamic_cast< Wt::WDateEdit* >( cw-> children().at(0) );
   196	
   197	#ifndef NEVER
   198	  std::cout << __FILE__ << ":" << __LINE__
   199	    << " Wt::cpp17::any DateDelegate::editState()"
   200	    << " r:" << _index.row()
   201	    << " c:" << _index.column()
   202	    << " i:" << cw-> id()
   203	    << " n:" << cw-> objectName()
   204	    << " s:" << cw-> children().size()
   205	    << " t:" << typeid( cw-> children().at(0) ).name()
   206	    << " d:" << de
   207	    << " m:" << m_dateEdit
   208	    << " t:" << m_dateEdit-> text()
   209	    << std::endl
   210	    ;
   211	#endif
   212	
   213	//  return "";
   214	  return m_dateEdit-> text();
   215	
   216	} // endWt::cpp17::any DateDelegate::editState( Wt::WWidget * _editor, const Wt::WModelIndex & _index ) const
   217	
   218	void
   219	DateDelegate::
   220	setEditState( Wt::WWidget * _editor, const Wt::WModelIndex & _index, const Wt::cpp17::any & _value ) const
   221	{
   222	//  the '_editor' and 'm_dateEdit' are not the same widget
   223	#ifdef NEVER
   224	  std::cout << __FILE__ << ":" << __LINE__ << " " << _editor    << " " << typeid( _editor ).name()    << std::endl;
   225	  std::cout << __FILE__ << ":" << __LINE__ << " " << m_dateEdit << " " << typeid( m_dateEdit ).name() << std::endl;
   226	#endif
   227	
   228	  Wt::WItemDelegate::setEditState( _editor, _index, _value );
   229	
   230	} // endvoid DateDelegate::setEditState( Wt::WWidget * _editor, const Wt::WModelIndex & _index, const Wt::cpp17::any & _value ) const
   231	
   232	void
   233	DateDelegate::
   234	setModelData( const Wt::cpp17::any & _editState, Wt::WAbstractItemModel * _model, const Wt::WModelIndex & _index ) const
   235	{
   236	#ifdef NEVER
   237	  std::cout << __FILE__ << ":" << __LINE__
   238	    << " setModelData()"
   239	    << " " << _index.row()
   240	    << " " << _index.column()
   241	    << " " << Wt::asString( _editState )
   242	    << " " << _model
   243	    << std::endl;
   244	#endif
   245	
   246	  Wt::WItemDelegate::setModelData( _editState, _model, _index );
   247	
   248	} // endvoid DateDelegate::setModelData( const Wt::cpp17::any & _editState, Wt::WAbstractItemModel * _model, const Wt::WModelIndex & _index ) const
   249	

