#include <Wt/WApplication.h>
#include <Wt/WContainerwidget.h>
#include <Wt/WEnvironment.h>
#include <Wt/WBootstrap5Theme.h>

#include "NavBar.h"

using namespace Wt;

std::unique_ptr<WApplication> createApplication( const WEnvironment& env )
{
   std::unique_ptr<WApplication> App = std::make_unique<WApplication>( env );
   if( App->appRoot().empty() )
   {
      std::cerr << "!!!!!!!!!!" << std::endl
         << "!! Warning: read the README.md file for hints on deployment,"
         << " the approot looks suspect!" << std::endl
         << "!!!!!!!!!!" << std::endl;
   }

   /* Not sure how to get app to recognize resources without specifying hard coded directory in /resource-dir launch
    parameters [--approot="./approot" --docroot=".;favicon.ico" --http-address 0.0.0.0 --http-port 8080]
    */
   //App->setInternalPath("/");
   App->setTitle( "Test Application" );
   auto BootStrapTheme = std::make_shared<WBootstrap5Theme>();
   App->setTheme( BootStrapTheme );
   App->useStyleSheet( "resources/themes/bootstrap/5/bootstrap-theme.min.css");

   App->root()->addWidget( std::make_unique<CNavBar>() );

   return App;
}

int main( int argc, char** argv )
{
   return WRun( argc, argv, &createApplication );
}

