#include <Wt/WApplication.h>

#include <Wt/WTemplate.h>
#include <Wt/WPushButton.h>

#include <Wt/WSignal.h>

namespace TestCase
{
namespace SegfaultOnF5
{
    class Application;

    std::unique_ptr<Application> createApplication(const Wt::WEnvironment& env);

    class DefaultWidget : public Wt::WContainerWidget
    {
    public:
        DefaultWidget();

        void setupForFail();

        void handlePathChange(const std::string& path);

    private:
        void createLayout();
        void setupConnections();

    private:
        Wt::WTemplate *tmpl_Layout;
        Wt::WPushButton *btn_Fail;
        Wt::WPushButton *btn_Success;
        Wt::WContainerWidget *faultContainer;
    };

    class Application : public Wt::WApplication
    {
    public:
        Application(const Wt::WEnvironment &env);
        ~Application() = default;

        void handlePathChange(const std::string& path);

    private: 
        void createLayout();
        void setupConnections();
        
    private:
        /* data */
        DefaultWidget *wgt_Default;
    };
    
    
}
}