//---------------------------------------------------------------------------
/*
About, class for containing information about a program
Copyright (C) 2010 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/CppAbout.htm
//---------------------------------------------------------------------------
#include <algorithm>
//---------------------------------------------------------------------------
#include <boost/foreach.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/version.hpp>
//---------------------------------------------------------------------------
#include "about.h"
//---------------------------------------------------------------------------
About::About(
    const std::string author,
    const std::string file_title,
    const std::string file_description,
    const std::string programmed_at,
    const std::string years,
    const std::string url,
    const std::string version,
    const std::vector<std::string>& version_history)
  : m_author(author),
    m_file_title(file_title),
    m_file_description(file_description),
    m_programmed_at(programmed_at),
    m_years(years),
    m_url(url),
    m_version(version),
    m_version_history(version_history)
{
  AddLibrary(
    std::string("About version: ")
    + GetAboutVersion());
  AddLibrary(
    std::string("Boost version: ")
    + GetBoostVersion());
  AddLibrary(
    std::string("STL version: ")
    + GetStlVersion()
    + std::string(" (GNU ISO C++ library)"));
}
//---------------------------------------------------------------------------
void About::AddLibrary(const std::string& s)
{
  m_libraries.push_back(s);
  std::sort(m_libraries.begin(),m_libraries.end());
}
//---------------------------------------------------------------------------
const std::vector<std::string> About::CreateAboutText() const
{
  std::vector<std::string> v;
  v.push_back(
    m_file_title
    + std::string(", version ")
    + m_version);
  v.push_back(
    std::string("Copyright (C) ")
    + m_years
    + std::string(" ")
    + m_author);
  v.push_back(
    std::string("Programmed at ")
    + m_programmed_at);
  v.push_back(
    std::string("by ")
    + m_author);
  v.push_back("");
  v.push_back(
    m_file_title
    + std::string(" can be downloaded from ")
    + m_url);
  v.push_back("Licenced under GPL 3.0");
  return v;
}
//---------------------------------------------------------------------------
const std::vector<std::string> About::CreateLibrariesUsedText() const
{
  std::vector<std::string> v;
  v.push_back("Libraries and classes used: ");
  BOOST_FOREACH(const std::string& s, m_libraries)
  {
    v.push_back(std::string(" * ") + s);
  }
  return v;
}
//---------------------------------------------------------------------------
///CreateLicence creates a GPL 3.0 licence.
const std::vector<std::string> About::CreateLicenceText() const
{
  std::vector<std::string> v;
  v.push_back(
    m_file_title
    + std::string(", ")
    + m_file_description);
  v.push_back(
      std::string("Copyright (C) ")
    + m_years
    + std::string(" ")
    + m_author);
  v.push_back("");
  v.push_back("This program is free software: you can redistribute it and/or modify");
  v.push_back("it under the terms of the GNU General Public License as published by");
  v.push_back("the Free Software Foundation, either version 3 of the License, or");
  v.push_back("(at your option) any later version.");
  v.push_back("");
  v.push_back("This program is distributed in the hope that it will be useful,");
  v.push_back("but WITHOUT ANY WARRANTY; without even the implied warranty of");
  v.push_back("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the");
  v.push_back("GNU General Public License for more details.");
  v.push_back("You should have received a copy of the GNU General Public License");
  v.push_back("along with this program. If not, see <http://www.gnu.org/licenses/>.");
  return v;
}
//---------------------------------------------------------------------------
const std::vector<std::string> About::CreateVersionHistory() const
{
  std::vector<std::string> v;
  v.push_back("Version history:");
  v.push_back(" * YYYY-MM-DD: version X.Y: [description]");
  BOOST_FOREACH(const std::string& s, m_version_history)
  {
    v.push_back(std::string(" * ") + s);
  }
  return v;
}
//---------------------------------------------------------------------------
///GetBoostVersion returns the version of the current Boost library.
///From http://www.richelbilderbeek.nl/CppGetBoostVersion.htm
const std::string About::GetBoostVersion()
{
  std::string s = BOOST_LIB_VERSION;
  std::replace(s.begin(),s.end(),'_','.');
  return s;
}
//---------------------------------------------------------------------------
///GetStlVersion returns the version number of the GCC STL currently installed.
///From http://www.richelbilderbeek.nl/CppGetStlVersion.htm
const std::string About::GetStlVersion()
{
  return boost::lexical_cast<std::string>(__VERSION__);
}
//---------------------------------------------------------------------------
const std::string About::GetAboutVersion()
{
  return "1.1";
}
//---------------------------------------------------------------------------
const std::vector<std::string> About::GetAboutVersionHistory()
{
  std::vector<std::string> v;
  v.push_back("2011-01-07: version 1.0: initial version");
  v.push_back("2011-01-11: version 1.1: added simple getters");
  return v;
}
//---------------------------------------------------------------------------


