//---------------------------------------------------------------------------
/*
About, class for containing information about a program
Copyright (C) 2010 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/CppAbout.htm
//---------------------------------------------------------------------------
#ifndef ABOUT_H
#define ABOUT_H
//---------------------------------------------------------------------------
#include <iosfwd>
#include <string>
#include <vector>
//---------------------------------------------------------------------------
struct About
{
  About(
    const std::string author,
    const std::string file_title,
    const std::string file_description,
    const std::string programmed_at,
    const std::string years,
    const std::string url,
    const std::string version,
    const std::vector<std::string>& version_history);

  void AddLibrary(const std::string& s);

  const std::vector<std::string> CreateAboutText() const;
  const std::vector<std::string> CreateVersionHistory() const;
  const std::vector<std::string> CreateLibrariesUsedText() const;
  const std::vector<std::string> CreateLicenceText() const;

  static const std::string GetAboutVersion();
  static const std::vector<std::string> GetAboutVersionHistory();
  const std::string& GetAuthor() const { return m_author; }
  static const std::string GetBoostVersion();
  const std::string& GetFileTitle() const { return m_file_title; }
  const std::string& GetProgrammedAt() const { return m_programmed_at; }
  static const std::string GetStlVersion();
  const std::string& GetUrl() const { return m_url; }
  const std::string& GetYears() const { return m_years; }

  const std::string& GetVersion() const { return m_version; }

  private:
  const std::string m_author;
  const std::string m_file_title;
  const std::string m_file_description;
  std::vector<std::string> m_libraries;
  const std::string m_programmed_at;
  const std::string m_years;
  const std::string m_url;
  const std::string m_version;
  const std::vector<std::string> m_version_history;

};
//---------------------------------------------------------------------------
#endif // ABOUT_H
